/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.annotation;

import io.microsphere.spring.beans.factory.support.BeanRegistrar;
import io.microsphere.spring.core.annotation.AnnotationUtils;
import io.microsphere.spring.web.annotation.EnableWebExtension;
import io.microsphere.spring.web.event.WebEventPublisher;
import io.microsphere.spring.web.metadata.SimpleWebEndpointMappingRegistry;
import io.microsphere.spring.web.method.support.DelegatingHandlerMethodAdvice;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

public class WebExtensionBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    public static final Class<EnableWebExtension> ANNOTATION_CLASS = EnableWebExtension.class;
    public static final String ANNOTATION_CLASS_NAME = ANNOTATION_CLASS.getName();

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = this.getAttributes(metadata);
        this.registerWebEndpointMappingRegistry(attributes, registry);
        this.registerDelegatingHandlerMethodAdvice(attributes, registry);
        this.registerEventPublishingProcessor(attributes, registry);
    }

    private AnnotationAttributes getAttributes(AnnotationMetadata metadata) {
        return AnnotationUtils.getAnnotationAttributes((AnnotationMetadata)metadata, (String)ANNOTATION_CLASS_NAME);
    }

    private void registerWebEndpointMappingRegistry(AnnotationAttributes attributes, BeanDefinitionRegistry registry) {
        boolean registerWebEndpointMappings = attributes.getBoolean("registerWebEndpointMappings");
        if (registerWebEndpointMappings) {
            BeanRegistrar.registerBeanDefinition((BeanDefinitionRegistry)registry, SimpleWebEndpointMappingRegistry.class);
        }
    }

    private void registerDelegatingHandlerMethodAdvice(AnnotationAttributes attributes, BeanDefinitionRegistry registry) {
        boolean interceptHandlerMethods = attributes.getBoolean("interceptHandlerMethods");
        if (interceptHandlerMethods) {
            String beanName = "delegatingHandlerMethodAdvice";
            BeanRegistrar.registerBeanDefinition((BeanDefinitionRegistry)registry, (String)beanName, DelegatingHandlerMethodAdvice.class);
        }
    }

    private void registerEventPublishingProcessor(AnnotationAttributes attributes, BeanDefinitionRegistry registry) {
        boolean publishEvents = attributes.getBoolean("publishEvents");
        if (publishEvents) {
            BeanRegistrar.registerBeanDefinition((BeanDefinitionRegistry)registry, WebEventPublisher.class);
        }
    }
}

