/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.metadata;

import io.microsphere.filter.Filter;
import io.microsphere.filter.FilterOperator;
import io.microsphere.lang.function.Streams;
import io.microsphere.spring.web.metadata.WebEndpointMapping;
import io.microsphere.spring.web.metadata.WebEndpointMappingFilter;
import io.microsphere.spring.web.metadata.WebEndpointMappingRegistry;
import io.microsphere.util.ArrayUtils;
import java.util.List;

public abstract class FilteringWebEndpointMappingRegistry
implements WebEndpointMappingRegistry {
    protected static final Filter<WebEndpointMapping> DEFAULT_FILTER = e -> true;
    protected static final FilterOperator DEFAULT_FILTER_OPERATOR = FilterOperator.OR;
    private Filter<WebEndpointMapping> compositeFilter = DEFAULT_FILTER;
    private FilterOperator filterOperator = DEFAULT_FILTER_OPERATOR;

    @Override
    public final int register(Iterable<WebEndpointMapping> webEndpointMappings) {
        int size;
        List<WebEndpointMapping> filteredWebEndpointMappings = this.filterWebEndpointMappings(webEndpointMappings);
        int count = size = filteredWebEndpointMappings.size();
        for (int i = 0; i < size; ++i) {
            WebEndpointMapping filteredWebEndpointMapping = filteredWebEndpointMappings.get(i);
            if (this.register(filteredWebEndpointMapping)) continue;
            --count;
        }
        return count;
    }

    protected List<WebEndpointMapping> filterWebEndpointMappings(Iterable<WebEndpointMapping> webEndpointMappings) {
        return Streams.filterList(webEndpointMappings, arg_0 -> this.getCompositeFilter().accept(arg_0));
    }

    public void setFilterOperator(FilterOperator filterOperator) {
        this.filterOperator = filterOperator;
    }

    public void setWebEndpointMappingFilters(Iterable<WebEndpointMappingFilter> filters) {
        this.setWebEndpointMappingFilters((WebEndpointMappingFilter[])ArrayUtils.asArray(filters, WebEndpointMappingFilter.class));
    }

    public void setWebEndpointMappingFilters(WebEndpointMappingFilter ... filters) {
        this.compositeFilter = this.getFilterOperator().createFilter((Filter[])filters);
    }

    public Filter<WebEndpointMapping> getCompositeFilter() {
        if (this.compositeFilter == null) {
            return DEFAULT_FILTER;
        }
        return this.compositeFilter;
    }

    public FilterOperator getFilterOperator() {
        if (this.filterOperator == null) {
            return DEFAULT_FILTER_OPERATOR;
        }
        return this.filterOperator;
    }
}

