/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.rule;

import io.microsphere.spring.web.rule.GenericMediaTypeExpression;
import io.microsphere.spring.web.rule.WebRequestHeaderExpression;
import io.microsphere.util.ArrayUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.http.MediaType;

public class ConsumeMediaTypeExpression
extends GenericMediaTypeExpression {
    public ConsumeMediaTypeExpression(String expression) {
        super(expression);
    }

    public ConsumeMediaTypeExpression(MediaType mediaType, boolean negated) {
        super(mediaType, negated);
    }

    public final boolean match(MediaType contentType) {
        boolean match = this.getMediaType().includes(contentType);
        return !this.isNegated() == match;
    }

    public static List<ConsumeMediaTypeExpression> parseExpressions(String[] consumes, @Nullable String[] headers) {
        LinkedHashSet<ConsumeMediaTypeExpression> result = null;
        if (!ArrayUtils.isEmpty((Object[])headers)) {
            for (String header : headers) {
                WebRequestHeaderExpression expression = new WebRequestHeaderExpression(header);
                if (!"Content-Type".equalsIgnoreCase(expression.name) || expression.value == null) continue;
                result = result != null ? result : new LinkedHashSet<ConsumeMediaTypeExpression>();
                List mediaTypes = MediaType.parseMediaTypes((String)((String)expression.value));
                for (MediaType mediaType : mediaTypes) {
                    result.add(new ConsumeMediaTypeExpression(mediaType, expression.isNegated));
                }
            }
        }
        if (!ArrayUtils.isEmpty((Object[])consumes)) {
            result = result != null ? result : new LinkedHashSet<ConsumeMediaTypeExpression>();
            for (String consume : consumes) {
                result.add(new ConsumeMediaTypeExpression(consume));
            }
        }
        return result != null ? new ArrayList(result) : Collections.emptyList();
    }
}

