/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.rule;

import io.microsphere.spring.web.rule.MediaTypeExpression;
import javax.annotation.Nullable;
import org.springframework.http.MediaType;

public class GenericMediaTypeExpression
implements MediaTypeExpression,
Comparable<GenericMediaTypeExpression> {
    private final MediaType mediaType;
    private final boolean isNegated;

    public GenericMediaTypeExpression(String expression) {
        if (expression.startsWith("!")) {
            this.isNegated = true;
            expression = expression.substring(1);
        } else {
            this.isNegated = false;
        }
        this.mediaType = MediaType.parseMediaType((String)expression);
    }

    GenericMediaTypeExpression(MediaType mediaType, boolean negated) {
        this.mediaType = mediaType;
        this.isNegated = negated;
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public boolean isNegated() {
        return this.isNegated;
    }

    @Override
    public int compareTo(GenericMediaTypeExpression other) {
        return MediaType.SPECIFICITY_COMPARATOR.compare(this.getMediaType(), other.getMediaType());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GenericMediaTypeExpression otherExpr = (GenericMediaTypeExpression)other;
        return this.mediaType.equals((Object)otherExpr.mediaType) && this.isNegated == otherExpr.isNegated;
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }

    public String toString() {
        if (this.isNegated) {
            return '!' + this.mediaType.toString();
        }
        return this.mediaType.toString();
    }

    public static GenericMediaTypeExpression of(String expression) {
        return new GenericMediaTypeExpression(expression);
    }
}

