/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.rule;

import io.microsphere.spring.web.rule.NameValueExpression;
import javax.annotation.Nullable;
import org.springframework.util.ObjectUtils;

public class StringNameValueExpression
implements NameValueExpression<String> {
    protected final String expression;
    protected final boolean caseSensitiveName;
    protected final String name;
    @Nullable
    protected final String value;
    protected final boolean isNegated;

    public StringNameValueExpression(String expression) {
        this(expression, true);
    }

    public StringNameValueExpression(String expression, boolean caseSensitiveName) {
        this.expression = expression;
        this.caseSensitiveName = caseSensitiveName;
        int separator = expression.indexOf(61);
        if (separator == -1) {
            this.isNegated = expression.startsWith("!");
            this.name = this.isNegated ? expression.substring(1) : expression;
            this.value = null;
        } else {
            this.isNegated = separator > 0 && expression.charAt(separator - 1) == '!';
            this.name = this.isNegated ? expression.substring(0, separator - 1) : expression.substring(0, separator);
            this.value = expression.substring(separator + 1);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isNegated() {
        return this.isNegated;
    }

    protected boolean isCaseSensitiveName() {
        return this.caseSensitiveName;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !NameValueExpression.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        NameValueExpression that = (NameValueExpression)other;
        return (this.isCaseSensitiveName() ? this.name.equals(that.getName()) : this.name.equalsIgnoreCase(that.getName())) && ObjectUtils.nullSafeEquals((Object)this.value, that.getValue()) && this.isNegated == that.isNegated();
    }

    public int hashCode() {
        int result = this.isCaseSensitiveName() ? this.name.hashCode() : this.name.toLowerCase().hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.isNegated ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.expression;
    }

    public static StringNameValueExpression of(String expression) {
        return new StringNameValueExpression(expression);
    }
}

