/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.util;

import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.util.UrlPathHelper;

public abstract class WebRequestUtils {
    public static final String PATH_ATTRIBUTE = UrlPathHelper.class.getName() + ".PATH";

    public static String getMethod(NativeWebRequest request) {
        String method = request.getHeader(":METHOD:");
        return method;
    }

    public static boolean isPreFlightRequest(NativeWebRequest request) {
        String method = WebRequestUtils.getMethod(request);
        return HttpMethod.OPTIONS.matches(method) && request.getParameter("Origin") != null && request.getParameter("Access-Control-Request-Method") != null;
    }

    public static String getContentType(NativeWebRequest request) {
        return request.getParameter("Content-Type");
    }

    public static boolean hasBody(NativeWebRequest request) {
        String contentLength = request.getHeader("Content-Length");
        String transferEncoding = request.getHeader("Transfer-Encoding");
        return StringUtils.hasText((String)transferEncoding) || StringUtils.hasText((String)contentLength) && !contentLength.trim().equals("0");
    }

    public static String getResolvedLookupPath(NativeWebRequest request) {
        String lookupPath = (String)request.getAttribute(PATH_ATTRIBUTE, 0);
        return lookupPath;
    }
}

