/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.metadata;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.core.io.support.SpringFactoriesLoaderUtils;
import io.microsphere.spring.web.metadata.WebEndpointMapping;
import io.microsphere.spring.web.metadata.WebEndpointMappingFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class SmartWebEndpointMappingFactory
implements WebEndpointMappingFactory<Object> {
    private static final Class<WebEndpointMappingFactory> FACTORY_CLASS = WebEndpointMappingFactory.class;
    private static final Logger logger = LoggerFactory.getLogger(FACTORY_CLASS);
    private final Map<Class<?>, List<WebEndpointMappingFactory>> delegates;

    SmartWebEndpointMappingFactory() {
        this(null);
    }

    public SmartWebEndpointMappingFactory(@Nullable ConfigurableListableBeanFactory beanFactory) {
        this.delegates = this.loadDelegates(beanFactory);
    }

    private Map<Class<?>, List<WebEndpointMappingFactory>> loadDelegates(@Nullable ConfigurableListableBeanFactory beanFactory) {
        List<WebEndpointMappingFactory> factories = this.doLoadFactories(beanFactory);
        Collection<WebEndpointMappingFactory> factoryBeans = this.getFactoryBeans(beanFactory);
        int size = factories.size() + factoryBeans.size();
        HashMap delegates = new HashMap(size);
        this.initDelegates(factories, delegates);
        this.initDelegates(factoryBeans, delegates);
        return delegates;
    }

    private Collection<WebEndpointMappingFactory> getFactoryBeans(ConfigurableListableBeanFactory beanFactory) {
        return beanFactory == null ? Collections.emptyList() : beanFactory.getBeansOfType(FACTORY_CLASS).values();
    }

    private void initDelegates(Collection<WebEndpointMappingFactory> factories, Map<Class<?>, List<WebEndpointMappingFactory>> delegates) {
        for (WebEndpointMappingFactory factory : factories) {
            Class sourceType = factory.getSourceType();
            List factoriesList = delegates.computeIfAbsent(sourceType, t -> new LinkedList());
            factoriesList.add(factory);
            AnnotationAwareOrderComparator.sort((List)factoriesList);
        }
    }

    private List<WebEndpointMappingFactory> doLoadFactories(ConfigurableListableBeanFactory beanFactory) {
        return SpringFactoriesLoaderUtils.loadFactories((BeanFactory)beanFactory, FACTORY_CLASS);
    }

    @Override
    public Optional<WebEndpointMapping<Object>> create(Object endpoint) {
        WebEndpointMappingFactory factory;
        int size;
        Class<?> sourceType = endpoint.getClass();
        List<WebEndpointMappingFactory> factories = this.delegates.get(sourceType);
        int n = size = factories == null ? 0 : factories.size();
        if (size < 1) {
            return null;
        }
        Optional<WebEndpointMapping<Object>> result = null;
        for (int i = 0; !(i >= size || (factory = factories.get(i)).supports(endpoint) && (result = factory.create(endpoint)) != null); ++i) {
        }
        return result;
    }
}

