/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.rule;

import io.microsphere.spring.web.rule.GenericMediaTypeExpression;
import io.microsphere.spring.web.rule.WebRequestHeaderExpression;
import io.microsphere.util.ArrayUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;

public class ProduceMediaTypeExpression
extends GenericMediaTypeExpression {
    public ProduceMediaTypeExpression(String expression) {
        super(expression);
    }

    public ProduceMediaTypeExpression(MediaType mediaType, boolean negated) {
        super(mediaType, negated);
    }

    public final boolean match(List<MediaType> acceptedMediaTypes) {
        boolean match = this.matchMediaType(acceptedMediaTypes);
        return !this.isNegated() == match;
    }

    private boolean matchMediaType(List<MediaType> acceptedMediaTypes) {
        for (MediaType acceptedMediaType : acceptedMediaTypes) {
            if (!this.getMediaType().isCompatibleWith(acceptedMediaType) || !this.matchParameters(acceptedMediaType)) continue;
            return true;
        }
        return false;
    }

    private boolean matchParameters(MediaType acceptedMediaType) {
        for (String name : this.getMediaType().getParameters().keySet()) {
            String s1 = this.getMediaType().getParameter(name);
            String s2 = acceptedMediaType.getParameter(name);
            if (!StringUtils.hasText((String)s1) || !StringUtils.hasText((String)s2) || s1.equalsIgnoreCase(s2)) continue;
            return false;
        }
        return true;
    }

    public static List<ProduceMediaTypeExpression> parseExpressions(String[] produces, @Nullable String[] headers) {
        LinkedHashSet<ProduceMediaTypeExpression> result = null;
        if (!ArrayUtils.isEmpty((Object[])headers)) {
            for (String header : headers) {
                WebRequestHeaderExpression expression = new WebRequestHeaderExpression(header);
                if (!"Accept".equalsIgnoreCase(expression.name) || expression.value == null) continue;
                List mediaTypes = MediaType.parseMediaTypes((String)((String)expression.value));
                for (MediaType mediaType : mediaTypes) {
                    result = result != null ? result : new LinkedHashSet<ProduceMediaTypeExpression>();
                    result.add(new ProduceMediaTypeExpression(mediaType, expression.isNegated));
                }
            }
        }
        if (!ArrayUtils.isEmpty((Object[])produces)) {
            for (String produce : produces) {
                result = result != null ? result : new LinkedHashSet<ProduceMediaTypeExpression>();
                result.add(new ProduceMediaTypeExpression(produce));
            }
        }
        return result != null ? new ArrayList(result) : Collections.emptyList();
    }
}

