/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.rule;

import io.microsphere.spring.web.rule.AbstractWebRequestRule;
import io.microsphere.spring.web.rule.ConsumeMediaTypeExpression;
import io.microsphere.spring.web.util.WebRequestUtils;
import java.util.Collection;
import java.util.List;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;

public class WebRequestConsumesRule
extends AbstractWebRequestRule<ConsumeMediaTypeExpression> {
    private final List<ConsumeMediaTypeExpression> expressions;

    public WebRequestConsumesRule(String ... consumes) {
        this(consumes, (String[])null);
    }

    public WebRequestConsumesRule(String[] consumes, String ... headers) {
        this.expressions = ConsumeMediaTypeExpression.parseExpressions(consumes, headers);
    }

    @Override
    protected Collection<ConsumeMediaTypeExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public boolean matches(NativeWebRequest request) {
        MediaType contentType;
        if (WebRequestUtils.isPreFlightRequest(request)) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        try {
            String contentTypeValue = WebRequestUtils.getContentType(request);
            contentType = StringUtils.hasLength((String)contentTypeValue) ? MediaType.parseMediaType((String)contentTypeValue) : MediaType.APPLICATION_OCTET_STREAM;
        }
        catch (InvalidMediaTypeException ex) {
            return false;
        }
        int size = this.expressions.size();
        for (int i = 0; i < size; ++i) {
            ConsumeMediaTypeExpression expression = this.expressions.get(i);
            if (expression.match(contentType)) continue;
            return false;
        }
        return true;
    }
}

