/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.rule;

import io.microsphere.collection.CollectionUtils;
import io.microsphere.spring.web.rule.AbstractWebRequestRule;
import io.microsphere.spring.web.rule.ProduceMediaTypeExpression;
import io.microsphere.spring.web.util.WebRequestUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.http.MediaType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.HttpMediaTypeException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.NativeWebRequest;

public class WebRequestProducesRule
extends AbstractWebRequestRule<ProduceMediaTypeExpression> {
    private static final ContentNegotiationManager DEFAULT_CONTENT_NEGOTIATION_MANAGER = new ContentNegotiationManager();
    private static final List<ProduceMediaTypeExpression> MEDIA_TYPE_ALL_LIST = Collections.singletonList(new ProduceMediaTypeExpression("*/*"));
    private static final String MEDIA_TYPES_ATTRIBUTE = WebRequestProducesRule.class.getName() + ".MEDIA_TYPES";
    private final List<ProduceMediaTypeExpression> expressions;
    private final ContentNegotiationManager contentNegotiationManager;

    public WebRequestProducesRule(String ... produces) {
        this(produces, (String[])null);
    }

    public WebRequestProducesRule(String[] produces, String ... headers) {
        this(produces, headers, (ContentNegotiationManager)null);
    }

    public WebRequestProducesRule(String[] produces, @Nullable String[] headers, @Nullable ContentNegotiationManager manager) {
        this.expressions = ProduceMediaTypeExpression.parseExpressions(produces, headers);
        if (this.expressions.size() > 1) {
            Collections.sort(this.expressions);
        }
        this.contentNegotiationManager = manager != null ? manager : DEFAULT_CONTENT_NEGOTIATION_MANAGER;
    }

    @Override
    protected Collection<ProduceMediaTypeExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public boolean matches(NativeWebRequest request) {
        List<MediaType> acceptedMediaTypes;
        if (WebRequestUtils.isPreFlightRequest(request)) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        try {
            acceptedMediaTypes = this.getAcceptedMediaTypes(request);
        }
        catch (HttpMediaTypeException ex) {
            return false;
        }
        List<ProduceMediaTypeExpression> result = this.getMatchingExpressions(acceptedMediaTypes);
        if (CollectionUtils.isNotEmpty(result)) {
            return false;
        }
        return !MimeTypeUtils.ALL.isPresentIn(acceptedMediaTypes);
    }

    @Nullable
    private List<ProduceMediaTypeExpression> getMatchingExpressions(List<MediaType> acceptedMediaTypes) {
        ArrayList<ProduceMediaTypeExpression> result = null;
        for (ProduceMediaTypeExpression expression : this.expressions) {
            if (!expression.match(acceptedMediaTypes)) continue;
            result = result != null ? result : new ArrayList<ProduceMediaTypeExpression>();
            result.add(expression);
        }
        return result;
    }

    private List<MediaType> getAcceptedMediaTypes(NativeWebRequest request) throws HttpMediaTypeNotAcceptableException {
        List result = (List)request.getAttribute(MEDIA_TYPES_ATTRIBUTE, 0);
        if (result == null) {
            result = this.contentNegotiationManager.resolveMediaTypes(request);
            request.setAttribute(MEDIA_TYPES_ATTRIBUTE, (Object)result, 0);
        }
        return result;
    }
}

