/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.webmvc.advice;

import io.microsphere.spring.webmvc.advice.ResponseBodyAdviceAdapter;
import io.microsphere.spring.webmvc.util.WebMvcUtils;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class StoringResponseBodyReturnValueAdvice
extends ResponseBodyAdviceAdapter<Object> {
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return WebMvcUtils.supportedConverterTypes.contains(converterType);
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        Method method = returnType.getMethod();
        if (request instanceof ServletServerHttpRequest) {
            ServletServerHttpRequest serverHttpRequest = (ServletServerHttpRequest)request;
            HttpServletRequest httpServletRequest = serverHttpRequest.getServletRequest();
            WebMvcUtils.setHandlerMethodReturnValue(httpServletRequest, method, body);
        }
        return body;
    }
}

