/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.webmvc.annotation;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.beans.factory.support.BeanRegistrar;
import io.microsphere.spring.core.annotation.AnnotationUtils;
import io.microsphere.spring.webmvc.advice.StoringRequestBodyArgumentAdvice;
import io.microsphere.spring.webmvc.advice.StoringResponseBodyReturnValueAdvice;
import io.microsphere.spring.webmvc.annotation.EnableWebMvcExtension;
import io.microsphere.spring.webmvc.interceptor.LazyCompositeHandlerInterceptor;
import io.microsphere.spring.webmvc.metadata.WebEndpointMappingRegistrar;
import io.microsphere.spring.webmvc.method.support.InterceptingHandlerMethodProcessor;
import io.microsphere.util.ArrayUtils;
import java.util.Arrays;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.web.servlet.HandlerInterceptor;

public class WebMvcExtensionBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger logger = LoggerFactory.getLogger(WebMvcExtensionBeanDefinitionRegistrar.class);
    public static final Class<EnableWebMvcExtension> ANNOTATION_CLASS = EnableWebMvcExtension.class;
    public static final String ANNOTATION_CLASS_NAME = ANNOTATION_CLASS.getName();
    private static final Class<? extends HandlerInterceptor>[] ALL_HANDLER_INTERCEPTOR_CLASSES = (Class[])ArrayUtils.of((Object[])new Class[]{HandlerInterceptor.class});

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = this.getAttributes(metadata);
        this.registerWebEndpointMappingRegistrar(attributes, registry);
        this.registerInterceptingHandlerMethodProcessor(attributes, registry);
        this.registerHandlerInterceptors(attributes, registry);
        this.registerStoringRequestBodyArgumentAdvice(attributes, registry);
        this.registerStoringResponseBodyReturnValueAdvice(attributes, registry);
    }

    private void registerWebEndpointMappingRegistrar(AnnotationAttributes attributes, BeanDefinitionRegistry registry) {
        boolean registerWebEndpointMappings = attributes.getBoolean("registerWebEndpointMappings");
        if (registerWebEndpointMappings) {
            BeanRegistrar.registerBeanDefinition((BeanDefinitionRegistry)registry, WebEndpointMappingRegistrar.class);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("@EnableWebMvcExtension.registerWebEndpointMappings = {}", new Object[]{registerWebEndpointMappings});
        }
    }

    private void registerInterceptingHandlerMethodProcessor(AnnotationAttributes attributes, BeanDefinitionRegistry registry) {
        boolean interceptHandlerMethods = attributes.getBoolean("interceptHandlerMethods");
        if (interceptHandlerMethods) {
            String beanName = "interceptingHandlerMethodProcessor";
            BeanRegistrar.registerBeanDefinition((BeanDefinitionRegistry)registry, (String)beanName, InterceptingHandlerMethodProcessor.class);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("@EnableWebMvcExtension.interceptHandlerMethods() = {}", new Object[]{interceptHandlerMethods});
        }
    }

    private AnnotationAttributes getAttributes(AnnotationMetadata metadata) {
        return AnnotationUtils.getAnnotationAttributes((AnnotationMetadata)metadata, (String)ANNOTATION_CLASS_NAME);
    }

    private void registerHandlerInterceptors(AnnotationAttributes attributes, BeanDefinitionRegistry registry) {
        Object[] interceptorClasses = this.resolveHandlerInterceptorClasses(attributes);
        if (ArrayUtils.isNotEmpty((Object[])interceptorClasses)) {
            this.registerLazyCompositeHandlerInterceptor(registry, (Class<? extends HandlerInterceptor>[])interceptorClasses);
            this.registerInterceptors(registry, (Class<? extends HandlerInterceptor>[])interceptorClasses);
        }
    }

    private Class<? extends HandlerInterceptor>[] resolveHandlerInterceptorClasses(AnnotationAttributes attributes) {
        Class<? extends HandlerInterceptor>[] handlerInterceptorClasses;
        boolean registerHandlerInterceptors = attributes.getBoolean("registerHandlerInterceptors");
        Class[] handlerInterceptors = attributes.getClassArray("handlerInterceptors");
        Class<Object>[] classArray = handlerInterceptorClasses = registerHandlerInterceptors ? ALL_HANDLER_INTERCEPTOR_CLASSES : handlerInterceptors;
        if (logger.isTraceEnabled()) {
            logger.trace("@EnableWebMvcExtension.registerHandlerInterceptors() = {} , handlerInterceptors() = {} , handlerInterceptorClasses = {}", new Object[]{registerHandlerInterceptors, handlerInterceptors, handlerInterceptorClasses});
        }
        return handlerInterceptorClasses;
    }

    private void registerLazyCompositeHandlerInterceptor(BeanDefinitionRegistry registry, Class<? extends HandlerInterceptor> ... interceptorClasses) {
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(LazyCompositeHandlerInterceptor.class).addConstructorArgValue(interceptorClasses).getBeanDefinition();
        registry.registerBeanDefinition("lazyCompositeHandlerInterceptor", (BeanDefinition)beanDefinition);
    }

    private void registerInterceptors(BeanDefinitionRegistry registry, Class<? extends HandlerInterceptor>[] interceptorClasses) {
        if (Arrays.equals(ALL_HANDLER_INTERCEPTOR_CLASSES, interceptorClasses)) {
            return;
        }
        for (Class<? extends HandlerInterceptor> interceptorClass : interceptorClasses) {
            this.registerInterceptor(registry, interceptorClass);
        }
    }

    private void registerInterceptor(BeanDefinitionRegistry registry, Class<? extends HandlerInterceptor> interceptorClass) {
        BeanRegistrar.registerBeanDefinition((BeanDefinitionRegistry)registry, interceptorClass);
    }

    private void registerStoringRequestBodyArgumentAdvice(AnnotationAttributes attributes, BeanDefinitionRegistry registry) {
        boolean storeRequestBodyArgument = attributes.getBoolean("storeRequestBodyArgument");
        if (storeRequestBodyArgument) {
            BeanRegistrar.registerBeanDefinition((BeanDefinitionRegistry)registry, StoringRequestBodyArgumentAdvice.class);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("@EnableWebMvcExtension.storeRequestBodyArgument() = {}", new Object[]{storeRequestBodyArgument});
        }
    }

    private void registerStoringResponseBodyReturnValueAdvice(AnnotationAttributes attributes, BeanDefinitionRegistry registry) {
        boolean storeResponseBodyReturnValue = attributes.getBoolean("storeResponseBodyReturnValue");
        if (storeResponseBodyReturnValue) {
            BeanRegistrar.registerBeanDefinition((BeanDefinitionRegistry)registry, StoringResponseBodyReturnValueAdvice.class);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("@EnableWebMvcExtension.storeResponseBodyReturnValue() = {}", new Object[]{storeResponseBodyReturnValue});
        }
    }
}

