/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.webmvc.annotation;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.webmvc.interceptor.LazyCompositeHandlerInterceptor;
import io.microsphere.util.ArrayUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

public class WebMvcExtensionConfiguration
extends WebMvcConfigurerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WebMvcExtensionConfiguration.class);
    private final ObjectProvider<LazyCompositeHandlerInterceptor[]> lazyCompositeHandlerInterceptorProvider;

    public WebMvcExtensionConfiguration(ObjectProvider<LazyCompositeHandlerInterceptor[]> lazyCompositeHandlerInterceptorProvider) {
        this.lazyCompositeHandlerInterceptorProvider = lazyCompositeHandlerInterceptorProvider;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        LazyCompositeHandlerInterceptor[] lazyCompositeHandlerInterceptors = (LazyCompositeHandlerInterceptor[])this.lazyCompositeHandlerInterceptorProvider.getIfAvailable();
        int length = ArrayUtils.length((Object[])lazyCompositeHandlerInterceptors);
        if (length == 0) {
            if (logger.isTraceEnabled()) {
                logger.trace("No LazyCompositeHandlerInterceptor Bean was registered.");
            }
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("{} LazyCompositeHandlerInterceptor Beans will be added into InterceptorRegistry.", new Object[]{length});
        }
        for (int i = 0; i < length; ++i) {
            LazyCompositeHandlerInterceptor lazyCompositeHandlerInterceptor = lazyCompositeHandlerInterceptors[i];
            registry.addInterceptor((HandlerInterceptor)lazyCompositeHandlerInterceptor);
        }
    }
}

