/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.webmvc.handler;

import io.microsphere.invoke.MethodHandleUtils;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.web.event.WebEndpointMappingsReadyEvent;
import io.microsphere.spring.web.metadata.WebEndpointMapping;
import io.microsphere.util.ArrayUtils;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationListener;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class ReversedProxyHandlerMapping
extends AbstractHandlerMapping
implements ApplicationListener<WebEndpointMappingsReadyEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ReversedProxyHandlerMapping.class);
    public static final int DEFAULT_ORDER = -2147483647;
    private static final String getHandlerExecutionChainMethodName = "getHandlerExecutionChain";
    private static final MethodHandle getHandlerExecutionChainMethodHandle;
    private Map<Integer, WebEndpointMapping> webEndpointMappingsCache;

    public ReversedProxyHandlerMapping() {
        this.setOrder(-2147483647);
    }

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        int webEndpointMappingId = request.getIntHeader("microsphere_wem_id");
        if (webEndpointMappingId == -1) {
            return null;
        }
        WebEndpointMapping webEndpointMapping = this.webEndpointMappingsCache.get(webEndpointMappingId);
        if (webEndpointMapping == null) {
            return null;
        }
        HandlerExecutionChain handlerExecutionChain = this.getHandlerExecutionChain(webEndpointMapping, request);
        return handlerExecutionChain;
    }

    @Nullable
    protected HandlerExecutionChain getHandlerExecutionChain(WebEndpointMapping webEndpointMapping, HttpServletRequest request) {
        HandlerExecutionChain handlerExecutionChain = null;
        Object source = webEndpointMapping.getSource();
        if (source instanceof RequestMappingHandlerMapping) {
            HandlerMethod handlerMethod = (HandlerMethod)webEndpointMapping.getEndpoint();
            RequestMappingHandlerMapping handlerMapping = (RequestMappingHandlerMapping)source;
            HandlerMethod handler = handlerMethod;
            MethodHandle methodHandle = getHandlerExecutionChainMethodHandle;
            if (methodHandle != null) {
                try {
                    handlerExecutionChain = methodHandle.invokeExact(handlerMapping, handler, request);
                }
                catch (Throwable e) {
                    logger.error("The method {}{} can't be executed in the {}", new Object[]{getHandlerExecutionChainMethodName, methodHandle.type(), handlerMapping.getClass().getName()});
                }
            }
        }
        return handlerExecutionChain;
    }

    public void onApplicationEvent(WebEndpointMappingsReadyEvent event) {
        HashMap<Integer, WebEndpointMapping> webEndpointMappingsMap = new HashMap<Integer, WebEndpointMapping>();
        event.getMappings().stream().filter(this::isRequestMappingHandlerMapping).forEach(webEndpointMapping -> webEndpointMappingsMap.put(webEndpointMapping.getId(), (WebEndpointMapping)webEndpointMapping));
        this.webEndpointMappingsCache = webEndpointMappingsMap;
    }

    private boolean isRequestMappingHandlerMapping(WebEndpointMapping webEndpointMapping) {
        return WebEndpointMapping.Kind.WEB_MVC.equals((Object)webEndpointMapping.getKind()) && webEndpointMapping.getSource() instanceof RequestMappingHandlerMapping;
    }

    static {
        Class<AbstractHandlerMapping> declaredClass = AbstractHandlerMapping.class;
        String methodName = getHandlerExecutionChainMethodName;
        MethodHandle methodHandle = null;
        Object[] parameterTypes = (Class[])ArrayUtils.of((Object[])new Class[]{Object.class, HttpServletRequest.class});
        try {
            methodHandle = MethodHandleUtils.findVirtual(RequestMappingHandlerMapping.class, (String)methodName, (Class[])parameterTypes);
        }
        catch (Throwable e) {
            logger.error("The method {}{} can't be found in the {}", new Object[]{methodName, Arrays.toString(parameterTypes), declaredClass.getName(), e});
        }
        getHandlerExecutionChainMethodHandle = methodHandle;
    }
}

