/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.webmvc.interceptor;

import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.SetUtils;
import io.microsphere.lang.function.ThrowableConsumer;
import io.microsphere.lang.function.ThrowableFunction;
import io.microsphere.spring.context.event.OnceApplicationContextEventListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LazyCompositeHandlerInterceptor
extends OnceApplicationContextEventListener<ContextRefreshedEvent>
implements HandlerInterceptor {
    public static final String BEAN_NAME = "lazyCompositeHandlerInterceptor";
    private final Set<Class<? extends HandlerInterceptor>> interceptorClasses;
    private List<HandlerInterceptor> interceptors;

    public LazyCompositeHandlerInterceptor(Class<? extends HandlerInterceptor> ... interceptorClasses) {
        this.interceptorClasses = SetUtils.of((Object[])interceptorClasses);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return this.forEach((ThrowableFunction<HandlerInterceptor, Boolean>)((ThrowableFunction)interceptor -> interceptor.preHandle(request, response, handler)));
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        this.forEach((ThrowableConsumer<HandlerInterceptor>)((ThrowableConsumer)interceptor -> interceptor.postHandle(request, response, handler, modelAndView)));
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.forEach((ThrowableConsumer<HandlerInterceptor>)((ThrowableConsumer)interceptor -> interceptor.afterCompletion(request, response, handler, ex)));
    }

    protected void onApplicationContextEvent(ContextRefreshedEvent event) {
        ApplicationContext context = event.getApplicationContext();
        LinkedList<HandlerInterceptor> allInterceptors = new LinkedList<HandlerInterceptor>();
        for (Class<? extends HandlerInterceptor> interceptorClass : this.interceptorClasses) {
            Collection interceptors = context.getBeansOfType(interceptorClass).values();
            for (HandlerInterceptor interceptor : interceptors) {
                if (interceptor == this) continue;
                allInterceptors.add(interceptor);
            }
        }
        AnnotationAwareOrderComparator.sort(allInterceptors);
        this.interceptors = allInterceptors;
    }

    private void forEach(ThrowableConsumer<HandlerInterceptor> interceptorConsumer) throws Exception {
        this.forEach((ThrowableFunction<HandlerInterceptor, Boolean>)((ThrowableFunction)interceptor -> {
            interceptorConsumer.accept(interceptor);
            return Boolean.TRUE;
        }));
    }

    private Boolean forEach(ThrowableFunction<HandlerInterceptor, Boolean> interceptorFunction) throws Exception {
        List<HandlerInterceptor> interceptors = this.interceptors;
        int length = CollectionUtils.size(interceptors);
        for (int i = 0; i < length; ++i) {
            HandlerInterceptor interceptor = interceptors.get(i);
            try {
                Boolean result = (Boolean)interceptorFunction.apply((Object)interceptor);
                if (!Boolean.FALSE.equals(result)) continue;
                return Boolean.FALSE;
            }
            catch (Throwable e) {
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                throw new RuntimeException(e);
            }
        }
        return Boolean.TRUE;
    }
}

