/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.webmvc.util;

import io.microsphere.spring.web.servlet.util.WebUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.ClassLoaderUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.support.RequestContextUtils;

public abstract class WebMvcUtils {
    public static final String HANDLER_METHOD_ARGUMENTS_ATTRIBUTE_NAME_PREFIX = "HM.ARGS:";
    public static final String HANDLER_METHOD_REQUEST_BODY_ARGUMENT_ATTRIBUTE_NAME_PREFIX = "HM.RB.ARG:";
    public static final String HANDLER_METHOD_RETURN_VALUE_ATTRIBUTE_NAME_PREFIX = "HM.RV:";
    public static final Set<Class<? extends HttpMessageConverter<?>>> supportedConverterTypes;
    public static final String ABSTRACT_JSONP_RESPONSE_BODY_ADVICE_CLASS_NAME = "org.springframework.web.servlet.mvc.findWebApplicationContextMethod.annotation.AbstractJsonpResponseBodyAdvice";
    private static final boolean ABSTRACT_JSONP_RESPONSE_BODY_ADVICE_PRESENT;
    private static final String REQUEST_MAPPING_HANDLER_MAPPING_CONTEXT_NAME;
    private static final String INIT_PARAM_DELIMITERS = ",; \t\n";
    private static final Method findWebApplicationContextMethod;

    public static HttpServletRequest getHttpServletRequest() throws IllegalStateException {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = null;
        if (requestAttributes instanceof ServletRequestAttributes) {
            request = ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        return request;
    }

    public static HttpServletRequest getHttpServletRequest(WebRequest webRequest) {
        HttpServletRequest request = null;
        if (webRequest instanceof ServletWebRequest) {
            request = ((ServletWebRequest)webRequest).getRequest();
        }
        return request;
    }

    public static WebApplicationContext getWebApplicationContext() throws IllegalStateException {
        HttpServletRequest request = WebMvcUtils.getHttpServletRequest();
        if (request == null) {
            throw new IllegalStateException("Use it in your Servlet Web application!");
        }
        ServletContext servletContext = request.getServletContext();
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
    }

    public static void setHandlerMethodRequestBodyArgument(Method method, Object requestBodyArgument) {
        WebMvcUtils.setHandlerMethodRequestBodyArgument((ServletRequest)WebMvcUtils.getHttpServletRequest(), method, requestBodyArgument);
    }

    public static void setHandlerMethodReturnValue(HttpServletRequest request, Method method, Object returnValue) {
        String attributeName = WebMvcUtils.getHandlerMethodReturnValueAttributeName(method);
        if (request != null && returnValue != null) {
            request.setAttribute(attributeName, returnValue);
        }
    }

    public static void setHandlerMethodRequestBodyArgument(ServletRequest request, Method method, Object requestBodyArgument) {
        String attributeName = WebMvcUtils.getHandlerMethodRequestBodyArgumentAttributeName(method);
        if (request != null && requestBodyArgument != null) {
            request.setAttribute(attributeName, requestBodyArgument);
        }
    }

    public static <T> T getHandlerMethodRequestBodyArgument(ServletRequest request, HandlerMethod handlerMethod) {
        return WebMvcUtils.getHandlerMethodRequestBodyArgument(request, handlerMethod.getMethod());
    }

    public static <T> T getHandlerMethodRequestBodyArgument(ServletRequest request, Method method) {
        String attributeName = WebMvcUtils.getHandlerMethodRequestBodyArgumentAttributeName(method);
        return (T)(request == null ? null : request.getAttribute(attributeName));
    }

    public static Object[] getHandlerMethodArguments(WebRequest webRequest, HandlerMethod handlerMethod) {
        Method method = handlerMethod.getMethod();
        return WebMvcUtils.getHandlerMethodArguments(webRequest, method);
    }

    public static Object[] getHandlerMethodArguments(WebRequest webRequest, MethodParameter parameter) {
        Method method = parameter.getMethod();
        return WebMvcUtils.getHandlerMethodArguments(webRequest, method);
    }

    public static Object[] getHandlerMethodArguments(WebRequest webRequest, Method method) {
        HttpServletRequest request = WebMvcUtils.getHttpServletRequest(webRequest);
        Object[] arguments = request != null ? WebMvcUtils.getHandlerMethodArguments((ServletRequest)request, method) : new Object[method.getParameterCount()];
        return arguments;
    }

    public static Object[] getHandlerMethodArguments(ServletRequest request, HandlerMethod handlerMethod) {
        return WebMvcUtils.getHandlerMethodArguments(request, handlerMethod.getMethod());
    }

    public static Object[] getHandlerMethodArguments(ServletRequest request, Method method) {
        String attributeName = WebMvcUtils.getHandlerMethodArgumentsAttributeName(method);
        Object[] arguments = (Object[])request.getAttribute(attributeName);
        if (arguments == null) {
            arguments = new Object[method.getParameterCount()];
            request.setAttribute(attributeName, (Object)arguments);
        }
        return arguments;
    }

    public static Object[] getHandlerMethodArguments(Method method) {
        return WebMvcUtils.getHandlerMethodArguments((ServletRequest)WebMvcUtils.getHttpServletRequest(), method);
    }

    public static <T> T getHandlerMethodReturnValue(ServletRequest request, HandlerMethod handlerMethod) {
        Method method = handlerMethod.getMethod();
        return WebMvcUtils.getHandlerMethodReturnValue(request, method);
    }

    public static <T> T getHandlerMethodReturnValue(ServletRequest request, Method method) {
        String attributeName = WebMvcUtils.getHandlerMethodReturnValueAttributeName(method);
        return (T)request.getAttribute(attributeName);
    }

    public static <T> T getHandlerMethodReturnValue(Method method) {
        HttpServletRequest request = WebMvcUtils.getHttpServletRequest();
        return WebMvcUtils.getHandlerMethodReturnValue((ServletRequest)request, method);
    }

    public static boolean isControllerAdviceBeanType(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, ControllerAdvice.class) != null;
    }

    public static WebApplicationContext getWebApplicationContext(HttpServletRequest request, ServletContext servletContext) {
        WebApplicationContext webApplicationContext = null;
        if (findWebApplicationContextMethod != null) {
            try {
                webApplicationContext = (WebApplicationContext)ReflectionUtils.invokeMethod((Method)findWebApplicationContextMethod, null, (Object[])new Object[]{request, servletContext});
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (webApplicationContext == null) {
            webApplicationContext = RequestContextUtils.findWebApplicationContext((HttpServletRequest)request, (ServletContext)servletContext);
        }
        return webApplicationContext;
    }

    protected static String appendInitParameter(String existedParameterValue, String ... parameterValues) {
        Object[] existedParameterValues = StringUtils.hasLength((String)existedParameterValue) ? existedParameterValue.split(INIT_PARAM_DELIMITERS) : new String[]{};
        ArrayList<Object> parameterValuesList = new ArrayList<Object>();
        if (ArrayUtils.isNotEmpty((Object[])existedParameterValues)) {
            parameterValuesList.addAll(Arrays.asList(existedParameterValues));
        }
        parameterValuesList.addAll(Arrays.asList(parameterValues));
        String newParameterValue = StringUtils.arrayToDelimitedString((Object[])parameterValuesList.toArray(), (String)",");
        return newParameterValue;
    }

    public static void appendInitParameters(ServletContext servletContext, String parameterName, String ... parameterValues) {
        Assert.notNull((Object)servletContext, (String)"The argument 'servletContext' must not be null!");
        Assert.notNull((Object)parameterValues, (String)"The argument 'parameterValues' must not be null!");
        String existedParameterValue = servletContext.getInitParameter(parameterName);
        String newParameterValue = WebMvcUtils.appendInitParameter(existedParameterValue, parameterValues);
        if (StringUtils.hasLength((String)newParameterValue)) {
            servletContext.setInitParameter(parameterName, newParameterValue);
        }
    }

    public static void appendGlobalInitializerClassInitParameter(ServletContext servletContext, Class<? extends ApplicationContextInitializer> contextInitializerClass) {
        String contextInitializerClassName = contextInitializerClass.getName();
        WebMvcUtils.appendInitParameters(servletContext, "globalInitializerClasses", contextInitializerClassName);
    }

    public static void appendContextInitializerClassInitParameter(ServletContext servletContext, Class<? extends ApplicationContextInitializer> contextInitializerClass) {
        String contextInitializerClassName = contextInitializerClass.getName();
        WebMvcUtils.appendInitParameters(servletContext, "contextInitializerClasses", contextInitializerClassName);
    }

    public static void appendFrameworkServletContextInitializerClassInitParameter(ServletContext servletContext, Class<? extends ApplicationContextInitializer> contextInitializerClass) {
        Collection<? extends ServletRegistration> servletRegistrations = WebUtils.findServletRegistrations(servletContext, FrameworkServlet.class).values();
        for (ServletRegistration servletRegistration : servletRegistrations) {
            String contextInitializerClassName = servletRegistration.getInitParameter("contextInitializerClasses");
            String newContextInitializerClassName = WebMvcUtils.appendInitParameter(contextInitializerClassName, contextInitializerClass.getName());
            servletRegistration.setInitParameter("contextInitializerClasses", newContextInitializerClassName);
        }
    }

    public static boolean isPageRenderRequest(ModelAndView modelAndView) {
        if (modelAndView != null) {
            String viewName = modelAndView.getViewName();
            return StringUtils.hasText((String)viewName);
        }
        return false;
    }

    private static String getHandlerMethodRequestBodyArgumentAttributeName(Method method) {
        return HANDLER_METHOD_REQUEST_BODY_ARGUMENT_ATTRIBUTE_NAME_PREFIX + WebMvcUtils.getMethodInfo(method);
    }

    private static String getHandlerMethodReturnValueAttributeName(Method method) {
        return HANDLER_METHOD_RETURN_VALUE_ATTRIBUTE_NAME_PREFIX + WebMvcUtils.getMethodInfo(method);
    }

    private static String getHandlerMethodArgumentsAttributeName(Method method) {
        return HANDLER_METHOD_ARGUMENTS_ATTRIBUTE_NAME_PREFIX + WebMvcUtils.getMethodInfo(method);
    }

    private static String getMethodInfo(Method method) {
        return String.valueOf(method);
    }

    static {
        ABSTRACT_JSONP_RESPONSE_BODY_ADVICE_PRESENT = ClassLoaderUtils.isPresent((String)ABSTRACT_JSONP_RESPONSE_BODY_ADVICE_CLASS_NAME, (ClassLoader)WebMvcUtils.class.getClassLoader());
        REQUEST_MAPPING_HANDLER_MAPPING_CONTEXT_NAME = RequestMappingHandlerMapping.class.getName();
        findWebApplicationContextMethod = ReflectionUtils.findMethod(RequestContextUtils.class, (String)"findWebApplicationContext", (Class[])new Class[]{HttpServletRequest.class, ServletContext.class});
        HashSet<Class> converterTypes = new HashSet<Class>(3);
        converterTypes.add(MappingJackson2HttpMessageConverter.class);
        converterTypes.add(StringHttpMessageConverter.class);
        supportedConverterTypes = Collections.unmodifiableSet(converterTypes);
    }
}

