/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.servlet.filter;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class ContentCachingFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(ContentCachingFilter.class);
    public static final String RESPONSE_CONTENT_REQUEST_ATTRIBUTE_NAME = "_ContentCachingFilter_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper(response);
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
        }
        finally {
            responseWrapper.copyBodyToResponse();
        }
    }

    public static String getResponseContentAsString(ServletRequest request, ServletResponse response) {
        if (!(response instanceof ContentCachingResponseWrapper)) {
            return null;
        }
        String content = (String)request.getAttribute(RESPONSE_CONTENT_REQUEST_ATTRIBUTE_NAME);
        if (content != null) {
            return content;
        }
        ContentCachingResponseWrapper responseWrapper = (ContentCachingResponseWrapper)response;
        try {
            content = new String(responseWrapper.getContentAsByteArray(), response.getCharacterEncoding());
            request.setAttribute(RESPONSE_CONTENT_REQUEST_ATTRIBUTE_NAME, (Object)content);
        }
        catch (Throwable e) {
            logger.error("ContentCachingResponseWrapper convert failed, msg={}", new Object[]{e.getMessage()});
        }
        return content;
    }
}

