/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.servlet.util;

import io.microsphere.util.ClassLoaderUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.Registration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.ClassUtils;

public abstract class WebUtils {
    private static final boolean servlet3OrAbove;
    private static final String SERVLET_CONTAINER_INITIALIZER_CLASS_NAME = "jakarta.servlet.ServletContainerInitializer";

    public static boolean isRunningBelowServlet3Container() {
        return !servlet3OrAbove;
    }

    public static ServletContext getServletContext(HttpServletRequest request) {
        if (WebUtils.isRunningBelowServlet3Container()) {
            return request.getSession().getServletContext();
        }
        return request.getServletContext();
    }

    public static Map<String, ? extends FilterRegistration> findFilterRegistrations(ServletContext servletContext, Class<? extends Filter> filterClass) {
        Map filterRegistrationsMap = servletContext.getFilterRegistrations();
        return WebUtils.findRegistrations(servletContext, filterRegistrationsMap, filterClass);
    }

    public static Map<String, ? extends ServletRegistration> findServletRegistrations(ServletContext servletContext, Class<? extends Servlet> servletClass) {
        Map servletRegistrationsMap = servletContext.getServletRegistrations();
        return WebUtils.findRegistrations(servletContext, servletRegistrationsMap, servletClass);
    }

    protected static <R extends Registration> Map<String, R> findRegistrations(ServletContext servletContext, Map<String, R> registrationsMap, Class<?> targetClass) {
        if (registrationsMap.isEmpty()) {
            return Collections.emptyMap();
        }
        ClassLoader classLoader = servletContext.getClassLoader();
        LinkedHashMap<String, Registration> foundRegistrationsMap = new LinkedHashMap<String, Registration>();
        for (Map.Entry<String, R> entry : registrationsMap.entrySet()) {
            Registration registration = (Registration)entry.getValue();
            String className = registration.getClassName();
            Class registeredRegistrationClass = ClassUtils.resolveClassName((String)className, (ClassLoader)classLoader);
            if (!ClassUtils.isAssignable(targetClass, (Class)registeredRegistrationClass)) continue;
            String servletName = entry.getKey();
            foundRegistrationsMap.put(servletName, registration);
        }
        return Collections.unmodifiableMap(foundRegistrationsMap);
    }

    static {
        ClassLoader classLoader = WebUtils.class.getClassLoader();
        servlet3OrAbove = ClassLoaderUtils.isPresent((String)SERVLET_CONTAINER_INITIALIZER_CLASS_NAME, (ClassLoader)classLoader);
    }
}

