/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.webmvc.config;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.http.MediaType;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.DataBinder;
import org.springframework.web.accept.ContentNegotiationManagerFactoryBean;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class ConfigurableContentNegotiationManagerWebMvcConfigurer
implements WebMvcConfigurer {
    private static final String PROPERTY_SEPARATOR = ".";
    private static final Class<ContentNegotiationManagerFactoryBean> FACTORY_BEAN_FIELD_CLASS = ContentNegotiationManagerFactoryBean.class;
    private final Map<String, Object> propertyValues;

    public ConfigurableContentNegotiationManagerWebMvcConfigurer(Map<String, String> properties) {
        this.propertyValues = ConfigurableContentNegotiationManagerWebMvcConfigurer.resolveNestedMap(properties);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        ReflectionUtils.doWithFields(configurer.getClass(), field -> {
            boolean accessible = field.isAccessible();
            try {
                if (!accessible) {
                    field.setAccessible(true);
                }
                ContentNegotiationManagerFactoryBean factoryBean = (ContentNegotiationManagerFactoryBean)field.get(configurer);
                this.configureContentNegotiationManagerFactoryBean(factoryBean);
            }
            finally {
                if (!accessible) {
                    field.setAccessible(accessible);
                }
            }
        }, field -> {
            Class<?> fieldType = field.getType();
            return FACTORY_BEAN_FIELD_CLASS.isAssignableFrom(fieldType);
        });
    }

    protected void configureContentNegotiationManagerFactoryBean(ContentNegotiationManagerFactoryBean factoryBean) {
        DataBinder dataBinder = new DataBinder((Object)factoryBean);
        dataBinder.setDisallowedFields(new String[]{"contentNegotiationManager", "servletContext"});
        dataBinder.setAutoGrowNestedPaths(true);
        dataBinder.registerCustomEditor(MediaType.class, "defaultContentType", (PropertyEditor)new MediaTypePropertyEditor());
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        propertyValues.addPropertyValues(this.propertyValues);
        dataBinder.bind((PropertyValues)propertyValues);
    }

    private static Map<String, String> extraProperties(Map<String, Object> map) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    Map mapValue = (Map)value;
                    Map<String, String> subProperties = ConfigurableContentNegotiationManagerWebMvcConfigurer.extraProperties(mapValue);
                    for (Map.Entry<String, String> e : subProperties.entrySet()) {
                        String subKey = e.getKey();
                        String subValue = e.getValue();
                        properties.put(key + PROPERTY_SEPARATOR + subKey, subValue);
                    }
                    continue;
                }
                if (!(value instanceof String)) continue;
                String stringValue = (String)value;
                properties.put(key, stringValue);
            }
        }
        return properties;
    }

    public static Map<String, Object> resolveNestedMap(Map<String, String> properties) {
        LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String propertyName = entry.getKey();
            String propertyValue = entry.getValue();
            int index = propertyName.indexOf(PROPERTY_SEPARATOR);
            if (index > 0) {
                Map mapValue;
                String actualPropertyName = propertyName.substring(0, index);
                String subPropertyName = propertyName.substring(index + 1, propertyName.length());
                Object actualPropertyValue = nestedMap.get(actualPropertyName);
                if (actualPropertyValue == null) {
                    actualPropertyValue = new LinkedHashMap();
                    nestedMap.put(actualPropertyName, actualPropertyValue);
                }
                if (!(actualPropertyValue instanceof Map)) continue;
                Map nestedProperties = mapValue = (Map)actualPropertyValue;
                Map<String, String> subProperties = ConfigurableContentNegotiationManagerWebMvcConfigurer.extraProperties(nestedProperties);
                subProperties.put(subPropertyName, propertyValue);
                Map<String, Object> subNestedMap = ConfigurableContentNegotiationManagerWebMvcConfigurer.resolveNestedMap(subProperties);
                nestedProperties.putAll(subNestedMap);
                continue;
            }
            nestedMap.put(propertyName, propertyValue);
        }
        return nestedMap;
    }

    private static class MediaTypePropertyEditor
    extends PropertyEditorSupport {
        private MediaTypePropertyEditor() {
        }

        @Override
        public void setAsText(String text) {
            MediaType mediaType = MediaType.valueOf((String)text);
            this.setValue(mediaType);
        }
    }
}

