/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.webmvc.context;

import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.ContentNegotiatingViewResolver;

public class ExclusiveViewResolverApplicationListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Class<ViewResolver> VIEW_RESOLVER_CLASS = ViewResolver.class;
    private final String exclusiveViewResolverBeanName;

    public ExclusiveViewResolverApplicationListener(String exclusiveViewResolverBeanName) {
        this.exclusiveViewResolverBeanName = exclusiveViewResolverBeanName;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        this.configureExclusiveViewResolver(applicationContext);
    }

    private void configureExclusiveViewResolver(ApplicationContext applicationContext) {
        Map viewResolversMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, VIEW_RESOLVER_CLASS);
        int size = viewResolversMap.size();
        if (size < 2) {
            return;
        }
        ViewResolver exclusiveViewResolver = (ViewResolver)viewResolversMap.get(this.exclusiveViewResolverBeanName);
        if (exclusiveViewResolver == null) {
            throw new NoSuchBeanDefinitionException(VIEW_RESOLVER_CLASS, this.exclusiveViewResolverBeanName);
        }
        ContentNegotiatingViewResolver contentNegotiatingViewResolver = (ContentNegotiatingViewResolver)applicationContext.getBean(ContentNegotiatingViewResolver.class);
        contentNegotiatingViewResolver.setViewResolvers(Arrays.asList(exclusiveViewResolver));
    }
}

