/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.webmvc.interceptor;

import io.microsphere.spring.webmvc.interceptor.MethodHandlerInterceptor;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import org.springframework.core.ResolvableType;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;

public abstract class AnnotatedMethodHandlerInterceptor<A extends Annotation>
extends MethodHandlerInterceptor {
    private final Class<A> annotationType = this.resolveAnnotationType();

    private Class<A> resolveAnnotationType() {
        ResolvableType resolvableType = ResolvableType.forType(this.getClass());
        return resolvableType.getSuperType().getGeneric(new int[]{0}).resolve();
    }

    @Override
    protected final boolean preHandle(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod) throws Exception {
        A annotation = this.getMethodAnnotation(request, handlerMethod);
        if (annotation != null) {
            return this.preHandle(request, response, handlerMethod, annotation);
        }
        return true;
    }

    protected boolean preHandle(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, A annotation) throws Exception {
        return true;
    }

    @Override
    protected final void postHandle(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, ModelAndView modelAndView) throws Exception {
        A annotation = this.getMethodAnnotation(request, handlerMethod);
        if (annotation != null) {
            this.postHandle(request, response, handlerMethod, modelAndView, annotation);
        }
    }

    protected void postHandle(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, ModelAndView modelAndView, A annotation) throws Exception {
    }

    @Override
    protected final void afterCompletion(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, Exception ex) throws Exception {
        A annotation = this.getMethodAnnotation(request, handlerMethod);
        if (annotation != null) {
            this.afterCompletion(request, response, handlerMethod, ex, annotation);
        }
    }

    protected void afterCompletion(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, Exception ex, A annotation) throws Exception {
    }

    public final Class<A> getAnnotationType() {
        return this.annotationType;
    }

    protected final A getMethodAnnotation(HttpServletRequest request, HandlerMethod handlerMethod) {
        String attributeName;
        ServletContext servletContext = request.getServletContext();
        Annotation annotation = (Annotation)servletContext.getAttribute(attributeName = this.getAnnotationAttributeName(handlerMethod));
        if (annotation == null) {
            annotation = handlerMethod.getMethodAnnotation(this.getAnnotationType());
            servletContext.setAttribute(attributeName, (Object)annotation);
        }
        return (A)annotation;
    }

    private String getAnnotationAttributeName(HandlerMethod handlerMethod) {
        return this.getAnnotationType() + "@" + handlerMethod.toString();
    }
}

