/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.webmvc.metadata;

import java.util.Objects;
import org.springframework.util.Assert;

public class HandlerMetadata<H, M> {
    private final H handler;
    private final M metadata;

    public HandlerMetadata(H handler, M metadata) {
        Assert.notNull(handler, (String)"The 'handler' must not be null!");
        Assert.notNull(metadata, (String)"The 'metadata' must not be null!");
        this.handler = handler;
        this.metadata = metadata;
    }

    public H getHandler() {
        return this.handler;
    }

    public M getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandlerMetadata that = (HandlerMetadata)o;
        return Objects.equals(this.handler, that.handler) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.handler, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HandlerMetadata{");
        sb.append("handler=").append(this.handler);
        sb.append(", metadata=").append(this.metadata);
        sb.append('}');
        return sb.toString();
    }
}

