/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.webmvc.metadata;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.context.lifecycle.AbstractSmartLifecycle;
import io.microsphere.spring.web.metadata.FilterRegistrationWebEndpointMappingFactory;
import io.microsphere.spring.web.metadata.ServletRegistrationWebEndpointMappingFactory;
import io.microsphere.spring.web.metadata.WebEndpointMapping;
import io.microsphere.spring.web.metadata.WebEndpointMappingRegistry;
import io.microsphere.spring.webmvc.metadata.HandlerMetadata;
import io.microsphere.spring.webmvc.metadata.HandlerMetadataWebEndpointMappingFactory;
import io.microsphere.spring.webmvc.metadata.RequestMappingMetadata;
import io.microsphere.spring.webmvc.metadata.RequestMappingMetadataWebEndpointMappingFactory;
import io.microsphere.util.Version;
import jakarta.servlet.ServletContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

public class WebEndpointMappingRegistrar
extends AbstractSmartLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(WebEndpointMappingRegistrar.class);
    private final WebApplicationContext context;

    public WebEndpointMappingRegistrar(WebApplicationContext context) {
        this.context = context;
        this.setPhase(-2147483558);
    }

    protected void doStart() {
        this.registerWebEndpointMappings();
    }

    private void registerWebEndpointMappings() {
        WebEndpointMappingRegistry registry = this.getRegistry();
        Collection<WebEndpointMapping> webEndpointMappings = this.collectWebEndpointMappings();
        int count = registry.register(webEndpointMappings);
        logger.info("{} WebEndpointMappings were registered from the Spring context[id :'{}']", new Object[]{count, this.context.getId()});
    }

    private WebEndpointMappingRegistry getRegistry() {
        return (WebEndpointMappingRegistry)this.context.getBean(WebEndpointMappingRegistry.class);
    }

    private Collection<WebEndpointMapping> collectWebEndpointMappings() {
        Map handlerMappingsMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.context, HandlerMapping.class);
        HashMap<RequestMappingInfo, HandlerMethod> requestMappingInfoHandlerMethods = new HashMap<RequestMappingInfo, HandlerMethod>();
        LinkedList<WebEndpointMapping> webEndpointMappings = new LinkedList<WebEndpointMapping>();
        ServletContext servletContext = this.context.getServletContext();
        Version servletVersion = Version.of((int)servletContext.getMajorVersion(), (int)servletContext.getMinorVersion());
        if (Version.of((int)3).le(servletVersion)) {
            this.collectFromServletContext(servletContext, this.context, webEndpointMappings);
        }
        for (HandlerMapping handlerMapping : handlerMappingsMap.values()) {
            this.collectFromAbstractUrlHandlerMapping(handlerMapping, webEndpointMappings);
            this.collectFromRequestMappingInfoHandlerMapping(handlerMapping, requestMappingInfoHandlerMethods, webEndpointMappings);
        }
        return webEndpointMappings;
    }

    private void collectFromServletContext(ServletContext servletContext, WebApplicationContext context, List<WebEndpointMapping> webEndpointMappings) {
        this.collectFromFilters(servletContext, context, webEndpointMappings);
        this.collectFromServlets(servletContext, context, webEndpointMappings);
    }

    private void collectFromFilters(ServletContext servletContext, WebApplicationContext context, List<WebEndpointMapping> webEndpointMappings) {
        Map filterRegistrations = servletContext.getFilterRegistrations();
        if (filterRegistrations.isEmpty()) {
            return;
        }
        FilterRegistrationWebEndpointMappingFactory factory = new FilterRegistrationWebEndpointMappingFactory(servletContext);
        for (Map.Entry entry : filterRegistrations.entrySet()) {
            String filterName = (String)entry.getKey();
            Optional webEndpointMapping = factory.create((Object)filterName);
            webEndpointMapping.ifPresent(webEndpointMappings::add);
        }
    }

    private void collectFromServlets(ServletContext servletContext, WebApplicationContext context, List<WebEndpointMapping> webEndpointMappings) {
        Map servletRegistrations = servletContext.getServletRegistrations();
        if (servletRegistrations.isEmpty()) {
            return;
        }
        ServletRegistrationWebEndpointMappingFactory factory = new ServletRegistrationWebEndpointMappingFactory(servletContext);
        for (Map.Entry entry : servletRegistrations.entrySet()) {
            String servletName = (String)entry.getKey();
            Optional webEndpointMapping = factory.create((Object)servletName);
            webEndpointMapping.ifPresent(webEndpointMappings::add);
        }
    }

    private void collectFromAbstractUrlHandlerMapping(HandlerMapping handlerMapping, List<WebEndpointMapping> webEndpointMappings) {
        if (handlerMapping instanceof AbstractUrlHandlerMapping) {
            AbstractUrlHandlerMapping urlHandlerMapping = (AbstractUrlHandlerMapping)handlerMapping;
            Map handlerMap = urlHandlerMapping.getHandlerMap();
            if (handlerMap.isEmpty()) {
                return;
            }
            HandlerMetadataWebEndpointMappingFactory factory = new HandlerMetadataWebEndpointMappingFactory((HandlerMapping)urlHandlerMapping);
            for (Map.Entry entry : handlerMap.entrySet()) {
                HandlerMetadata metadata = new HandlerMetadata(entry.getValue(), (String)entry.getKey());
                Optional webEndpointMapping = factory.create(metadata);
                webEndpointMapping.ifPresent(webEndpointMappings::add);
            }
        }
    }

    private void collectFromRequestMappingInfoHandlerMapping(HandlerMapping handlerMapping, Map<RequestMappingInfo, HandlerMethod> requestMappingInfoHandlerMethods, List<WebEndpointMapping> webEndpointMappings) {
        if (handlerMapping instanceof RequestMappingInfoHandlerMapping) {
            RequestMappingInfoHandlerMapping requestMappingInfoHandlerMapping = (RequestMappingInfoHandlerMapping)handlerMapping;
            Map handlerMethodsMap = requestMappingInfoHandlerMapping.getHandlerMethods();
            if (handlerMethodsMap.isEmpty()) {
                return;
            }
            RequestMappingMetadataWebEndpointMappingFactory factory = new RequestMappingMetadataWebEndpointMappingFactory((HandlerMapping)requestMappingInfoHandlerMapping);
            for (Map.Entry entry : handlerMethodsMap.entrySet()) {
                RequestMappingMetadata metadata = new RequestMappingMetadata((RequestMappingInfo)entry.getKey(), (HandlerMethod)entry.getValue());
                Optional webEndpointMapping = factory.create(metadata);
                webEndpointMapping.ifPresent(webEndpointMappings::add);
            }
            requestMappingInfoHandlerMethods.putAll(handlerMethodsMap);
        }
    }

    protected void doStop() {
    }
}

