/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.webmvc.method.support;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.beans.BeanUtils;
import io.microsphere.spring.context.event.OnceApplicationContextEventListener;
import io.microsphere.spring.web.event.WebEndpointMappingsReadyEvent;
import io.microsphere.spring.web.metadata.WebEndpointMapping;
import io.microsphere.spring.web.method.support.HandlerMethodAdvice;
import io.microsphere.spring.webmvc.method.support.HandlerMethodArgumentResolverAdvice;
import io.microsphere.spring.webmvc.util.WebMvcUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

public class InterceptingHandlerMethodProcessor
extends OnceApplicationContextEventListener<WebEndpointMappingsReadyEvent>
implements HandlerMethodArgumentResolver,
HandlerMethodReturnValueHandler,
HandlerInterceptor {
    public static final String BEAN_NAME = "interceptingHandlerMethodProcessor";
    private static final Logger logger = LoggerFactory.getLogger(InterceptingHandlerMethodProcessor.class);
    private final Map<MethodParameter, MethodParameterContext> parameterContextsCache = new HashMap<MethodParameter, MethodParameterContext>(256);
    private final Map<MethodParameter, ReturnTypeContext> returnTypeContextsCache = new HashMap<MethodParameter, ReturnTypeContext>(256);
    @Nullable
    private HandlerMethodAdvice handlerMethodAdvice;
    private List<HandlerMethodArgumentResolverAdvice> advices = Collections.emptyList();
    private int advicesSize = 0;

    protected void onApplicationContextEvent(WebEndpointMappingsReadyEvent event) {
        ApplicationContext context = event.getApplicationContext();
        this.initAdvices(context);
        this.initHandlerMethodAdvice(context);
        this.initRequestMappingHandlerAdapters(event, context);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return true;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return true;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        MethodParameterContext methodParameterContext = this.getParameterContext(parameter);
        if (methodParameterContext == null) {
            logger.trace("The MethodParameterContext can't be found by the MethodParameter[{}]", new Object[]{parameter});
            return null;
        }
        HandlerMethodArgumentResolver resolver = methodParameterContext.resolver;
        this.beforeResolveArgument(parameter, methodParameterContext, mavContainer, webRequest, binderFactory);
        Object argument = resolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        this.afterResolveArgument(parameter, argument, methodParameterContext, mavContainer, webRequest, binderFactory);
        this.beforeExecute(parameter, methodParameterContext, webRequest, argument);
        return argument;
    }

    public void handleReturnValue(@Nullable Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        ReturnTypeContext context = this.getReturnTypeContext(returnType);
        if (context == null) {
            logger.trace("The ReturnTypeContext can't be found by the return type[{}]", new Object[]{returnType});
            return;
        }
        HandlerMethodReturnValueHandler handler = context.handler;
        HandlerMethod handlerMethod = context.method;
        this.afterExecute(webRequest, (Object)handlerMethod, context);
        handler.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception error) throws Exception {
        if (error != null) {
            this.afterExecute(request, handler, error);
        }
    }

    private void initAdvices(ApplicationContext context) {
        List advices;
        this.advices = advices = BeanUtils.getSortedBeans((ListableBeanFactory)context, HandlerMethodArgumentResolverAdvice.class);
        this.advicesSize = advices.size();
    }

    private void initHandlerMethodAdvice(ApplicationContext context) {
        this.handlerMethodAdvice = (HandlerMethodAdvice)BeanUtils.getOptionalBean((ListableBeanFactory)context, HandlerMethodAdvice.class);
    }

    private void initRequestMappingHandlerAdapters(WebEndpointMappingsReadyEvent event, ApplicationContext context) {
        Collection mappings = event.getMappings();
        List adapters = BeanUtils.getSortedBeans((ListableBeanFactory)context, RequestMappingHandlerAdapter.class);
        for (int i = 0; i < adapters.size(); ++i) {
            RequestMappingHandlerAdapter adapter = (RequestMappingHandlerAdapter)adapters.get(i);
            this.initRequestMappingHandlerAdapter(adapter, mappings);
        }
    }

    private void initRequestMappingHandlerAdapter(RequestMappingHandlerAdapter adapter, Collection<WebEndpointMapping> webEndpointMappings) {
        List resolvers = adapter.getArgumentResolvers();
        List handlers = adapter.getReturnValueHandlers();
        for (WebEndpointMapping webEndpointMapping : webEndpointMappings) {
            Object endpoint = webEndpointMapping.getEndpoint();
            if (!(endpoint instanceof HandlerMethod)) continue;
            HandlerMethod handlerMethod = (HandlerMethod)endpoint;
            MethodParameter[] methodParameters = handlerMethod.getMethodParameters();
            Method method = handlerMethod.getMethod();
            int parameterCount = method.getParameterCount();
            for (int i = 0; i < parameterCount; ++i) {
                MethodParameter methodParameter = methodParameters[i];
                this.initMethodParameterContextsCache(methodParameter, handlerMethod, parameterCount, resolvers);
            }
            this.initReturnTypeContextsCache(handlerMethod, handlers);
        }
        ArrayList<InterceptingHandlerMethodProcessor> newResolvers = new ArrayList<InterceptingHandlerMethodProcessor>(resolvers.size() + 1);
        newResolvers.add(this);
        newResolvers.addAll(resolvers);
        ArrayList<InterceptingHandlerMethodProcessor> newHandlers = new ArrayList<InterceptingHandlerMethodProcessor>(handlers.size() + 1);
        newHandlers.add(this);
        newHandlers.addAll(handlers);
        adapter.setArgumentResolvers(newResolvers);
        adapter.setReturnValueHandlers(newHandlers);
    }

    private void initMethodParameterContextsCache(MethodParameter methodParameter, HandlerMethod handlerMethod, int parameterCount, List<HandlerMethodArgumentResolver> resolvers) {
        HandlerMethodArgumentResolver resolver = this.resolveArgumentResolver(methodParameter, resolvers);
        if (resolver != null) {
            MethodParameterContext context = new MethodParameterContext();
            context.method = handlerMethod;
            context.parameterCount = parameterCount;
            context.resolver = resolver;
            this.parameterContextsCache.put(methodParameter, context);
        }
    }

    private void initReturnTypeContextsCache(HandlerMethod handlerMethod, List<HandlerMethodReturnValueHandler> handlers) {
        HandlerMethodReturnValueHandler handler = this.resolveReturnValueHandler(handlerMethod, handlers);
        if (handler != null) {
            ReturnTypeContext context = new ReturnTypeContext();
            context.method = handlerMethod;
            context.handler = handler;
            MethodParameter returnType = handlerMethod.getReturnType();
            this.returnTypeContextsCache.put(returnType, context);
        }
    }

    private MethodParameterContext getParameterContext(MethodParameter parameter) {
        return this.parameterContextsCache.get(parameter);
    }

    private ReturnTypeContext getReturnTypeContext(MethodParameter returnType) {
        return this.returnTypeContextsCache.get(returnType);
    }

    private HandlerMethod resolveHandlerMethod(Object handler) {
        HandlerMethod handlerMethod;
        return handler instanceof HandlerMethod ? (handlerMethod = (HandlerMethod)handler) : null;
    }

    private void beforeResolveArgument(MethodParameter parameter, MethodParameterContext methodParameterContext, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        for (int i = 0; i < this.advicesSize; ++i) {
            HandlerMethodArgumentResolverAdvice advice = this.advices.get(i);
            advice.beforeResolveArgument(parameter, mavContainer, webRequest, binderFactory);
        }
        HandlerMethodAdvice facade = this.handlerMethodAdvice;
        if (facade != null) {
            HandlerMethod handlerMethod = methodParameterContext.method;
            facade.beforeResolveArgument(parameter, handlerMethod, webRequest);
        }
    }

    private void afterResolveArgument(MethodParameter parameter, Object argument, MethodParameterContext methodParameterContext, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        for (int i = 0; i < this.advicesSize; ++i) {
            HandlerMethodArgumentResolverAdvice advice = this.advices.get(i);
            advice.afterResolveArgument(parameter, argument, mavContainer, webRequest, binderFactory);
        }
        HandlerMethodAdvice facade = this.handlerMethodAdvice;
        if (facade != null) {
            HandlerMethod handlerMethod = methodParameterContext.method;
            facade.afterResolveArgument(parameter, argument, handlerMethod, webRequest);
        }
    }

    private void beforeExecute(MethodParameter parameter, MethodParameterContext methodParameterContext, NativeWebRequest webRequest, Object argument) throws Exception {
        HandlerMethodAdvice facade = this.handlerMethodAdvice;
        if (facade != null) {
            int parameterCount = methodParameterContext.parameterCount;
            Object[] arguments = this.resolveArguments(parameter, argument, webRequest);
            int parameterIndex = parameter.getParameterIndex();
            if (parameterIndex == parameterCount - 1) {
                HandlerMethod handlerMethod = methodParameterContext.method;
                facade.beforeExecuteMethod(handlerMethod, arguments, webRequest);
            }
        }
    }

    private void afterExecute(NativeWebRequest webRequest, @Nullable Object returnValue, ReturnTypeContext context) throws Exception {
        HandlerMethod handlerMethod = context.method;
        Object[] arguments = this.getArguments(webRequest, handlerMethod);
        this.afterExecute(webRequest, handlerMethod, arguments, returnValue);
    }

    private void afterExecute(NativeWebRequest webRequest, HandlerMethod handlerMethod, Object[] args, @Nullable Object returnValue) throws Exception {
        this.afterExecute(webRequest, handlerMethod, args, returnValue, null);
    }

    private void afterExecute(HttpServletRequest request, Object handler, @Nullable Exception error) throws Exception {
        HandlerMethod handlerMethod = this.resolveHandlerMethod(handler);
        if (handlerMethod != null) {
            ServletWebRequest webRequest = new ServletWebRequest(request);
            Object[] arguments = this.getArguments(request, handlerMethod);
            this.afterExecute((NativeWebRequest)webRequest, handlerMethod, arguments, null, error);
        }
    }

    private void afterExecute(NativeWebRequest webRequest, HandlerMethod handlerMethod, Object[] arguments, @Nullable Object returnValue, @Nullable Exception error) throws Exception {
        HandlerMethodAdvice facade = this.handlerMethodAdvice;
        if (facade != null) {
            facade.afterExecuteMethod(handlerMethod, arguments, returnValue, (Throwable)error, webRequest);
        }
    }

    private Object[] getArguments(NativeWebRequest webRequest, HandlerMethod handlerMethod) {
        return WebMvcUtils.getHandlerMethodArguments((WebRequest)webRequest, handlerMethod);
    }

    private Object[] getArguments(HttpServletRequest request, HandlerMethod handlerMethod) {
        return WebMvcUtils.getHandlerMethodArguments((ServletRequest)request, handlerMethod);
    }

    private Object[] resolveArguments(MethodParameter parameter, Object argument, NativeWebRequest webRequest) {
        int index = parameter.getParameterIndex();
        Object[] arguments = null;
        if (argument != null && index < (arguments = WebMvcUtils.getHandlerMethodArguments((WebRequest)webRequest, parameter)).length) {
            arguments[index] = argument;
        }
        return arguments;
    }

    private HandlerMethodArgumentResolver resolveArgumentResolver(MethodParameter methodParameter, List<HandlerMethodArgumentResolver> resolvers) {
        int size = resolvers.size();
        HandlerMethodArgumentResolver targetResolver = null;
        for (int i = 0; i < size; ++i) {
            HandlerMethodArgumentResolver resolver = resolvers.get(i);
            if (!resolver.supportsParameter(methodParameter)) continue;
            if (targetResolver == null) {
                targetResolver = resolver;
                continue;
            }
            logger.warn("The HandlerMethodArgumentResolver[class : '{}'] also supports the MethodParameter[{}] , the mapped one : {}", new Object[]{this.getClassName(resolver), methodParameter, this.getClassName(targetResolver)});
        }
        return targetResolver;
    }

    private HandlerMethodReturnValueHandler resolveReturnValueHandler(HandlerMethod methodParameter, List<HandlerMethodReturnValueHandler> handlers) {
        MethodParameter returnType = methodParameter.getReturnType();
        int size = handlers.size();
        HandlerMethodReturnValueHandler targetHandler = null;
        for (int i = 0; i < size; ++i) {
            HandlerMethodReturnValueHandler handler = handlers.get(i);
            if (!handler.supportsReturnType(returnType)) continue;
            if (targetHandler == null) {
                targetHandler = handler;
                continue;
            }
            logger.warn("The HandlerMethodReturnValueHandler[class : '{}'] also supports the return type[{}] , the mapped one : {}", new Object[]{this.getClassName(handler), methodParameter, this.getClassName(targetHandler)});
        }
        return targetHandler;
    }

    private String getClassName(Object instance) {
        return instance.getClass().getName();
    }

    static class MethodParameterContext {
        private HandlerMethod method;
        private int parameterCount;
        private HandlerMethodArgumentResolver resolver;

        MethodParameterContext() {
        }
    }

    static class ReturnTypeContext {
        private HandlerMethod method;
        private HandlerMethodReturnValueHandler handler;

        ReturnTypeContext() {
        }
    }
}

