/*
 * Decompiled with CFR 0.152.
 */
package io.github.webauthn.jpa;

import io.github.webauthn.domain.WebAuthnCredentials;
import java.util.Arrays;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;

@Entity
public class JpaWebAuthnCredentials
implements WebAuthnCredentials {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    private byte[] credentialId;
    private Long appUserId;
    private Long count;
    @Lob
    private byte[] publicKeyCose;
    private String userAgent;

    public JpaWebAuthnCredentials(byte[] credentialId, Long appUserId, Long count, byte[] publicKeyCose, String userAgent) {
        this.credentialId = credentialId;
        this.appUserId = appUserId;
        this.count = count;
        this.publicKeyCose = publicKeyCose;
        this.userAgent = userAgent;
    }

    public JpaWebAuthnCredentials() {
    }

    public byte[] getCredentialId() {
        return this.credentialId;
    }

    public void setCredentialId(byte[] credentialId) {
        this.credentialId = credentialId;
    }

    public Long getAppUserId() {
        return this.appUserId;
    }

    public void setAppUserId(Long appUserId) {
        this.appUserId = appUserId;
    }

    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public byte[] getPublicKeyCose() {
        return this.publicKeyCose;
    }

    public void setPublicKeyCose(byte[] publicKeyCose) {
        this.publicKeyCose = publicKeyCose;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpaWebAuthnCredentials that = (JpaWebAuthnCredentials)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "WebAuthnCredentials{id=" + this.id + ", credentialId=" + Arrays.toString(this.credentialId) + ", appUserId=" + this.appUserId + "}";
    }
}

