/*
 * Decompiled with CFR 0.152.
 */
package io.github.webauthn.jpa;

import io.github.webauthn.domain.WebAuthnCredentialsRepository;
import io.github.webauthn.jpa.JpaWebAuthnCredentials;
import io.github.webauthn.jpa.WebAuthnCredentialsSpringDataRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SpringDataWebAuthnCredentialsRepositoryAdapter
implements WebAuthnCredentialsRepository<JpaWebAuthnCredentials> {
    private final WebAuthnCredentialsSpringDataRepository webAuthnCredentialsRepository;

    public SpringDataWebAuthnCredentialsRepositoryAdapter(WebAuthnCredentialsSpringDataRepository webAuthnCredentialsRepository) {
        this.webAuthnCredentialsRepository = webAuthnCredentialsRepository;
    }

    public List<JpaWebAuthnCredentials> findAllByAppUserId(Long userId) {
        return this.webAuthnCredentialsRepository.findAllByAppUserId(userId);
    }

    public Optional<JpaWebAuthnCredentials> findByCredentialIdAndAppUserId(byte[] credentialId, Long userId) {
        return this.webAuthnCredentialsRepository.findByCredentialIdAndAppUserId(credentialId, userId);
    }

    public List<JpaWebAuthnCredentials> findByCredentialId(byte[] credentialId) {
        return this.webAuthnCredentialsRepository.findByCredentialId(credentialId);
    }

    public JpaWebAuthnCredentials save(JpaWebAuthnCredentials credentials) {
        return this.webAuthnCredentialsRepository.save(credentials);
    }

    public void deleteByAppUserId(Long appUserId) {
        this.webAuthnCredentialsRepository.deleteByAppUserId(appUserId);
    }

    public void deleteById(Long id) {
        this.webAuthnCredentialsRepository.deleteById(id);
    }

    public JpaWebAuthnCredentials save(byte[] credentialId, Long appUserId, Long count, byte[] publicKeyCose, String userAgent) {
        return this.webAuthnCredentialsRepository.save(new JpaWebAuthnCredentials(credentialId, appUserId, count, publicKeyCose, userAgent));
    }
}

