/*
 * Decompiled with CFR 0.152.
 */
package io.github.webauthn.jpa;

import io.github.webauthn.domain.WebAuthnUserRepository;
import io.github.webauthn.dto.RegistrationStartRequest;
import io.github.webauthn.jpa.JpaWebAuthnUser;
import io.github.webauthn.jpa.WebAuthnUserSpringDataRepository;
import java.time.LocalDateTime;
import java.util.Optional;

public class SpringDataWebAuthnUserRepositoryAdapter
implements WebAuthnUserRepository<JpaWebAuthnUser> {
    private final WebAuthnUserSpringDataRepository webAuthnUserSpringDataRepository;

    public SpringDataWebAuthnUserRepositoryAdapter(WebAuthnUserSpringDataRepository webAuthnUserSpringDataRepository) {
        this.webAuthnUserSpringDataRepository = webAuthnUserSpringDataRepository;
    }

    public JpaWebAuthnUser save(JpaWebAuthnUser user) {
        return (JpaWebAuthnUser)this.webAuthnUserSpringDataRepository.save(user);
    }

    public Optional<JpaWebAuthnUser> findById(Long id) {
        return this.webAuthnUserSpringDataRepository.findById(id);
    }

    public Optional<JpaWebAuthnUser> findByUsername(String username) {
        return this.webAuthnUserSpringDataRepository.findByUsername(username);
    }

    public Optional<JpaWebAuthnUser> findByAddTokenAndRegistrationAddStartAfter(byte[] token, LocalDateTime after) {
        return this.webAuthnUserSpringDataRepository.findByAddTokenAndRegistrationAddStartAfter(token, after);
    }

    public Optional<JpaWebAuthnUser> findByRecoveryToken(byte[] token) {
        return this.webAuthnUserSpringDataRepository.findByRecoveryToken(token);
    }

    public void deleteById(Long id) {
        this.webAuthnUserSpringDataRepository.deleteById(id);
    }

    public JpaWebAuthnUser newUser(RegistrationStartRequest startRequest) {
        JpaWebAuthnUser u = new JpaWebAuthnUser();
        u.setUsername(startRequest.getUsername());
        u.setFirstName(startRequest.getFirstName());
        u.setLastName(startRequest.getLastName());
        return u;
    }
}

