/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.crate;

import io.github.milkdrinkers.crate.internal.FileType;
import io.github.milkdrinkers.crate.internal.FlatFile;
import io.github.milkdrinkers.crate.internal.provider.InputStreamProvider;
import io.github.milkdrinkers.crate.internal.settings.ConfigSetting;
import io.github.milkdrinkers.crate.internal.settings.DataType;
import io.github.milkdrinkers.crate.internal.settings.ReloadSetting;
import io.github.milkdrinkers.crate.util.FileUtils;
import io.github.milkdrinkers.crate.util.Valid;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConfigurationBuilder<T extends AbstractConfigurationBuilder<T, R>, R> {
    private final InputStreamProvider inputStreamProvider;
    private final FileType fileType;
    private String fileName;
    private String directoryPath;
    private InputStream defaultDataStream;
    private ReloadSetting reloadSetting;
    private ConfigSetting configSetting;
    private DataType dataType;
    @Nullable
    private Consumer<FlatFile> reloadCallback = null;

    protected AbstractConfigurationBuilder(InputStreamProvider inputStreamProvider, FileType fileType) {
        Valid.notNull(inputStreamProvider, "InputStreamProvider cannot be null");
        Valid.notNull(fileType, "FileType cannot be null");
        this.inputStreamProvider = inputStreamProvider;
        this.fileType = fileType;
    }

    public T path(String path) {
        Valid.notNull(path, "Path cannot be null or empty");
        Valid.checkBoolean(!path.isEmpty(), "Path cannot be null or empty");
        return this.path(new File(path));
    }

    public T path(Path path) {
        Valid.notNull(path, "Path cannot be null");
        return this.path(path.toFile());
    }

    public T path(File file) {
        Valid.notNull(file, "File cannot be null");
        if (!file.isDirectory()) {
            this.fileName = file.getName();
            this.directoryPath = FileUtils.getParentDirPath(file);
        } else {
            Valid.checkBoolean(!file.getName().contains("."), "Directory name must not contain '.' when used as file location");
            if (!file.exists()) {
                file.mkdirs();
            }
            this.fileName = file.getName() + "." + this.fileType.getExtension();
            this.directoryPath = file.getAbsolutePath();
        }
        return this.self();
    }

    public T path(URI uri) {
        Valid.notNull(uri, "URI cannot be null");
        return this.path(Paths.get(uri));
    }

    public T path(String directory, String filename) {
        Valid.notNull(directory, "Directory cannot be null or empty");
        Valid.checkBoolean(!directory.isEmpty(), "Directory cannot be null or empty");
        Valid.notNull(filename, "Filename cannot be null or empty");
        Valid.checkBoolean(!filename.isEmpty(), "Filename cannot be null or empty");
        return this.path(new File(directory, this.ensureExtension(filename)));
    }

    public T path(File directory, String filename) {
        Valid.notNull(directory, "Directory cannot be null");
        Valid.notNull(filename, "Filename cannot be null or empty");
        Valid.checkBoolean(!filename.isEmpty(), "Filename cannot be null or empty");
        return this.path(new File(directory, this.ensureExtension(filename)));
    }

    public T defaults(@Nullable Path path) {
        if (path == null) {
            this.defaultDataStream = null;
            return this.self();
        }
        return this.defaults(path.toFile());
    }

    public T defaults(@Nullable File file) {
        if (file == null) {
            this.defaultDataStream = null;
            return this.self();
        }
        this.defaultDataStream = FileUtils.createInputStream(file);
        return this.self();
    }

    public T defaults(@Nullable String resourcePath) {
        if (resourcePath == null || resourcePath.isEmpty()) {
            this.defaultDataStream = null;
            return this.self();
        }
        InputStream inputStream = this.inputStreamProvider.createInputStreamFromInnerResource(resourcePath);
        if (inputStream == null) {
            throw new IllegalArgumentException("Resource not found: " + resourcePath);
        }
        return this.defaults(inputStream);
    }

    public T defaults(@Nullable InputStream inputStream) {
        this.defaultDataStream = inputStream;
        return this.self();
    }

    public T defaults(@Nullable URL url) {
        if (url == null) {
            this.defaultDataStream = null;
            return this.self();
        }
        try {
            this.defaultDataStream = url.openStream();
            return this.self();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to open stream from URL: " + url, e);
        }
    }

    public T reloadCallback(@Nullable Consumer<FlatFile> reloadCallback) {
        this.reloadCallback = reloadCallback;
        return this.self();
    }

    public T config(@NonNull ConfigSetting configSetting) {
        if (configSetting == null) {
            throw new NullPointerException("configSetting is marked non-null but is null");
        }
        Valid.notNull(configSetting, "ConfigSetting cannot be null");
        this.configSetting = configSetting;
        return this.self();
    }

    public T reload(@NonNull ReloadSetting reloadSetting) {
        if (reloadSetting == null) {
            throw new NullPointerException("reloadSetting is marked non-null but is null");
        }
        Valid.notNull(reloadSetting, "ReloadSetting cannot be null");
        this.reloadSetting = reloadSetting;
        return this.self();
    }

    public T dataType(@NonNull DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        Valid.notNull(dataType, "DataType cannot be null");
        this.dataType = dataType;
        return this.self();
    }

    protected InputStreamProvider getInputStreamProvider() {
        return this.inputStreamProvider;
    }

    protected String getDirectoryPath() {
        return this.directoryPath;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected InputStream getDefaultDataStream() {
        return this.defaultDataStream;
    }

    protected ReloadSetting getReloadSetting() {
        return this.reloadSetting;
    }

    protected ConfigSetting getConfigSetting() {
        return this.configSetting;
    }

    protected DataType getDataType() {
        return this.dataType;
    }

    @Nullable
    protected Consumer<FlatFile> getReloadCallback() {
        return this.reloadCallback;
    }

    protected FileType getFileType() {
        return this.fileType;
    }

    public abstract R build();

    protected T self() {
        return (T)this;
    }

    private String ensureExtension(String filename) {
        String extension = "." + this.fileType.getExtension();
        return filename.endsWith(extension) ? filename : filename + extension;
    }
}

