/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.crate;

import io.github.milkdrinkers.crate.internal.FlatFile;
import io.github.milkdrinkers.crate.internal.provider.InputStreamProvider;
import io.github.milkdrinkers.crate.internal.settings.ConfigSetting;
import io.github.milkdrinkers.crate.internal.settings.DataType;
import io.github.milkdrinkers.crate.internal.settings.ReloadSetting;
import io.github.milkdrinkers.crate.util.FileUtils;
import io.github.milkdrinkers.crate.util.Valid;
import java.io.File;
import java.io.InputStream;
import java.util.function.Consumer;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCrateBuilder<T, Y> {
    private final InputStreamProvider inputStreamProvider;
    private final String path;
    private String name;
    private InputStream inputStream;
    private ReloadSetting reloadSetting;
    private ConfigSetting configSetting;
    private DataType dataType;
    @Nullable
    private Consumer<FlatFile> reloadConsumer = null;

    protected AbstractCrateBuilder(String name, String path, InputStreamProvider inputStreamProvider) {
        this.name = name;
        this.path = path;
        this.inputStreamProvider = inputStreamProvider;
    }

    public AbstractCrateBuilder<T, Y> reloadCallback(@Nullable Consumer<FlatFile> reloadConsumer) {
        this.reloadConsumer = reloadConsumer;
        return this;
    }

    public AbstractCrateBuilder<T, Y> addInputStreamFromFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.inputStream = FileUtils.createInputStream(file);
        return this;
    }

    public AbstractCrateBuilder<T, Y> addInputStreamFromResource(@NonNull String resource) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        this.inputStream = this.inputStreamProvider.createInputStreamFromInnerResource(resource);
        Valid.notNull(this.inputStream, "InputStream is null.", "No inbuilt resource '" + resource + "' found: ");
        return this;
    }

    public AbstractCrateBuilder<T, Y> setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        return this;
    }

    public AbstractCrateBuilder<T, Y> addInputStream(@Nullable InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public AbstractCrateBuilder<T, Y> setConfigSetting(@NonNull ConfigSetting configSetting) {
        if (configSetting == null) {
            throw new NullPointerException("configSetting is marked non-null but is null");
        }
        this.configSetting = configSetting;
        return this;
    }

    public AbstractCrateBuilder<T, Y> setReloadSetting(@NonNull ReloadSetting reloadSetting) {
        if (reloadSetting == null) {
            throw new NullPointerException("reloadSetting is marked non-null but is null");
        }
        this.reloadSetting = reloadSetting;
        return this;
    }

    public AbstractCrateBuilder<T, Y> setDataType(@NonNull DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        this.dataType = dataType;
        return this;
    }

    protected InputStreamProvider getInputStreamProvider() {
        return this.inputStreamProvider;
    }

    protected String getPath() {
        return this.path;
    }

    protected String getName() {
        return this.name;
    }

    protected InputStream getInputStream() {
        return this.inputStream;
    }

    protected ReloadSetting getReloadSetting() {
        return this.reloadSetting;
    }

    protected ConfigSetting getConfigSetting() {
        return this.configSetting;
    }

    protected DataType getDataType() {
        return this.dataType;
    }

    @Nullable
    protected Consumer<FlatFile> getReloadConsumer() {
        return this.reloadConsumer;
    }

    public abstract Y create();
}

