/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.crate;

import io.github.milkdrinkers.crate.Yaml;
import io.github.milkdrinkers.crate.internal.FlatFile;
import io.github.milkdrinkers.crate.internal.settings.ConfigSetting;
import io.github.milkdrinkers.crate.internal.settings.DataType;
import io.github.milkdrinkers.crate.internal.settings.ReloadSetting;
import java.io.File;
import java.io.InputStream;
import java.util.function.Consumer;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class Config
extends Yaml {
    public Config(@NonNull Config config) {
        super(config);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
    }

    public Config(String name, String path) {
        this(name, path, null, null, ConfigSetting.PRESERVE_COMMENTS, DataType.SORTED);
    }

    public Config(String name, @Nullable String path, @Nullable InputStream inputStream) {
        this(name, path, inputStream, null, ConfigSetting.PRESERVE_COMMENTS, DataType.SORTED);
    }

    public Config(String name, @Nullable String path, @Nullable InputStream inputStream, @Nullable ReloadSetting reloadSetting, @Nullable ConfigSetting configSetting, @Nullable DataType dataType) {
        super(name, path, inputStream, reloadSetting, configSetting, dataType);
        this.setConfigSetting(ConfigSetting.PRESERVE_COMMENTS);
    }

    public Config(String name, @Nullable String path, @Nullable InputStream inputStream, @Nullable ReloadSetting reloadSetting, @Nullable ConfigSetting configSetting, @Nullable DataType dataType, @Nullable Consumer<FlatFile> reloadConsumer) {
        super(name, path, inputStream, reloadSetting, configSetting, dataType, reloadConsumer);
        this.setConfigSetting(ConfigSetting.PRESERVE_COMMENTS);
    }

    public Config(File file) {
        super(file);
    }

    @Override
    public Config addDefaultsFromInputStream() {
        return (Config)super.addDefaultsFromInputStream();
    }

    @Override
    public Config addDefaultsFromInputStream(@Nullable InputStream inputStream) {
        return (Config)super.addDefaultsFromInputStream(inputStream);
    }
}

