/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.crate;

import io.github.milkdrinkers.crate.internal.FileData;
import io.github.milkdrinkers.crate.internal.FileType;
import io.github.milkdrinkers.crate.internal.FlatFile;
import io.github.milkdrinkers.crate.internal.editor.yaml.YamlEditor;
import io.github.milkdrinkers.crate.internal.editor.yaml.YamlParser;
import io.github.milkdrinkers.crate.internal.editor.yaml.YamlWriter;
import io.github.milkdrinkers.crate.internal.provider.CrateProviders;
import io.github.milkdrinkers.crate.internal.settings.ConfigSetting;
import io.github.milkdrinkers.crate.internal.settings.DataType;
import io.github.milkdrinkers.crate.internal.settings.ReloadSetting;
import io.github.milkdrinkers.crate.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.Load;

public class Yaml
extends FlatFile {
    protected final InputStream inputStream;
    protected final YamlEditor yamlEditor;
    protected final YamlParser parser;
    private ConfigSetting configSetting = ConfigSetting.SKIP_COMMENTS;

    public Yaml(@NonNull Yaml yaml) {
        super(yaml.getFile());
        if (yaml == null) {
            throw new NullPointerException("yaml is marked non-null but is null");
        }
        this.fileData = yaml.getFileData();
        this.yamlEditor = yaml.getYamlEditor();
        this.parser = yaml.getParser();
        this.configSetting = yaml.getConfigSetting();
        this.inputStream = yaml.getInputStream().orElse(null);
        this.pathPrefix = yaml.getPathPrefix();
        this.reloadConsumer = yaml.getReloadConsumer();
    }

    public Yaml(String name, @Nullable String path) {
        this(name, path, null, null, null, null);
    }

    public Yaml(String name, @Nullable String path, @Nullable InputStream inputStream) {
        this(name, path, inputStream, null, null, null);
    }

    public Yaml(String name, @Nullable String path, @Nullable InputStream inputStream, @Nullable ReloadSetting reloadSetting, @Nullable ConfigSetting configSetting, @Nullable DataType dataType) {
        this(name, path, inputStream, reloadSetting, configSetting, dataType, null);
    }

    public Yaml(String name, @Nullable String path, @Nullable InputStream inputStream, @Nullable ReloadSetting reloadSetting, @Nullable ConfigSetting configSetting, @Nullable DataType dataType, @Nullable Consumer<FlatFile> reloadConsumer) {
        super(name, path, FileType.YAML, reloadConsumer);
        this.inputStream = inputStream;
        if (this.create() && inputStream != null) {
            FileUtils.writeToFile(this.file, inputStream);
        }
        this.yamlEditor = new YamlEditor(this.file);
        this.parser = new YamlParser(this.yamlEditor);
        if (reloadSetting != null) {
            this.reloadSetting = reloadSetting;
        }
        if (configSetting != null) {
            this.configSetting = configSetting;
        }
        this.dataType = dataType != null ? dataType : DataType.forConfigSetting(configSetting);
        this.forceReload();
    }

    public Yaml(File file) {
        this(file.getName(), FileUtils.getParentDirPath(file));
    }

    public Yaml addDefaultsFromInputStream() {
        return this.addDefaultsFromInputStream(this.getInputStream().orElse(null));
    }

    public Yaml addDefaultsFromInputStream(@Nullable InputStream inputStream) {
        this.reloadIfNeeded();
        if (inputStream == null) {
            return this;
        }
        try (InputStreamReader isr = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(isr);){
            Load yaml = new Load(CrateProviders.yamlLoaderOptions());
            Map data = (Map)yaml.loadFromReader(reader);
            FileData newData = new FileData(data, DataType.UNSORTED);
            for (String key : newData.keySet()) {
                if (this.fileData.containsKey(key)) continue;
                this.fileData.insert(key, newData.get(key));
            }
            this.write();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this;
    }

    @Override
    protected Map<String, Object> readToMap() throws IOException {
        Load yaml = new Load(CrateProviders.yamlLoaderOptions());
        Map data = (Map)yaml.loadFromInputStream(Files.newInputStream(this.getFile().toPath(), new OpenOption[0]));
        return data == null ? new HashMap() : data;
    }

    @Override
    protected void write(FileData data) throws IOException {
        if (!ConfigSetting.PRESERVE_COMMENTS.equals((Object)this.configSetting)) {
            this.write0(this.fileData);
            return;
        }
        FileUtils.writer(this.file, writer -> {
            Dump yaml = new Dump(CrateProviders.yamlDumperOptions());
            yaml.dump(this.fileData.toMap(), new YamlWriter((Writer)writer));
        });
    }

    private void write0(FileData fileData) throws IOException {
        try {
            FileUtils.writer(this.file, writer -> {
                Dump yaml = new Dump(CrateProviders.yamlDumperOptionsNoComments());
                yaml.dump(fileData.toMap(), new YamlWriter((Writer)writer));
            });
        }
        catch (IOException ex) {
            throw CrateProviders.exceptionHandler().create(ex, "Error while writing to '" + this.file.getName() + "'.", "In: '" + FileUtils.getParentDirPath(this.file) + "'");
        }
    }

    public final List<String> getHeader() {
        return this.yamlEditor.readHeader();
    }

    public final void setHeader(List<String> header) {
        this.yamlEditor.setHeader(header);
    }

    public final void setHeader(String ... header) {
        this.setHeader(Arrays.asList(header));
    }

    public final void addHeader(List<String> toAdd) {
        this.yamlEditor.addHeader(toAdd);
    }

    public final void addHeader(String ... header) {
        this.addHeader(Arrays.asList(header));
    }

    public final void framedHeader(String ... header) {
        ArrayList<String> stringList = new ArrayList<String>();
        String border = "# +----------------------------------------------------+ #";
        stringList.add(border);
        for (String line : header) {
            StringBuilder builder = new StringBuilder();
            if (line.length() > 50) continue;
            int length = (50 - line.length()) / 2;
            StringBuilder finalLine = new StringBuilder(line);
            for (int i = 0; i < length; ++i) {
                finalLine.append(" ");
                finalLine.reverse();
                finalLine.append(" ");
                finalLine.reverse();
            }
            if (line.length() % 2 != 0) {
                finalLine.append(" ");
            }
            builder.append("# < ").append((CharSequence)finalLine).append(" > #");
            stringList.add(builder.toString());
        }
        stringList.add(border);
        this.setHeader(stringList);
    }

    public final Optional<InputStream> getInputStream() {
        return Optional.ofNullable(this.inputStream);
    }

    @Generated
    public YamlEditor getYamlEditor() {
        return this.yamlEditor;
    }

    @Generated
    public YamlParser getParser() {
        return this.parser;
    }

    @Generated
    public ConfigSetting getConfigSetting() {
        return this.configSetting;
    }

    @Generated
    public void setConfigSetting(ConfigSetting configSetting) {
        this.configSetting = configSetting;
    }
}

