/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.crate;

import io.github.milkdrinkers.crate.AbstractCrateBuilder;
import io.github.milkdrinkers.crate.Yaml;
import io.github.milkdrinkers.crate.internal.provider.CrateProviders;
import io.github.milkdrinkers.crate.internal.provider.InputStreamProvider;
import io.github.milkdrinkers.crate.util.FileUtils;
import io.github.milkdrinkers.crate.util.Valid;
import java.io.File;
import java.nio.file.Path;
import lombok.NonNull;

public class YamlBuilder
extends AbstractCrateBuilder<YamlBuilder, Yaml> {
    private YamlBuilder(String name, String path, InputStreamProvider inputStreamProvider) {
        super(name, path, inputStreamProvider);
    }

    public static YamlBuilder fromPath(@NonNull String name, @NonNull String path) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new YamlBuilder(name, path, CrateProviders.inputStreamProvider());
    }

    public static YamlBuilder fromPath(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return YamlBuilder.fromFile(path.toFile());
    }

    public static YamlBuilder fromFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Valid.checkBoolean(!file.isDirectory(), "File mustn't be a directory.", "Please use from Directory to use a directory", "This is due to Java-Internals");
        return new YamlBuilder(FileUtils.replaceExtensions(file.getName()), FileUtils.getParentDirPath(file), CrateProviders.inputStreamProvider());
    }

    public static YamlBuilder fromDirectory(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Valid.checkBoolean(!file.getName().contains("."), "File-Name mustn't contain '.'");
        if (!file.exists()) {
            file.mkdirs();
        }
        return new YamlBuilder(file.getName(), file.getAbsolutePath(), CrateProviders.inputStreamProvider());
    }

    @Override
    public Yaml create() {
        return new Yaml(super.getName(), super.getPath(), super.getInputStream(), super.getReloadSetting(), super.getConfigSetting(), super.getDataType(), super.getReloadConsumer());
    }
}

