/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.crate.internal;

import io.github.milkdrinkers.crate.annotation.ConfigPath;
import io.github.milkdrinkers.crate.internal.DataStorage;
import io.github.milkdrinkers.crate.internal.FileData;
import io.github.milkdrinkers.crate.internal.FileType;
import io.github.milkdrinkers.crate.internal.provider.CrateProviders;
import io.github.milkdrinkers.crate.internal.settings.DataType;
import io.github.milkdrinkers.crate.internal.settings.ReloadSetting;
import io.github.milkdrinkers.crate.sections.FlatFileSection;
import io.github.milkdrinkers.crate.util.FileUtils;
import io.github.milkdrinkers.crate.util.Valid;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public abstract class FlatFile
implements DataStorage,
Comparable<FlatFile> {
    protected final File file;
    protected final FileType fileType;
    protected ReloadSetting reloadSetting = ReloadSetting.INTELLIGENT;
    protected DataType dataType = DataType.UNSORTED;
    protected FileData fileData;
    @Nullable
    protected Consumer<FlatFile> reloadConsumer;
    protected String pathPrefix;
    private long lastLoaded;

    protected FlatFile(@NonNull String name, @Nullable String path, @NonNull FileType fileType, @Nullable Consumer<FlatFile> reloadConsumer) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (fileType == null) {
            throw new NullPointerException("fileType is marked non-null but is null");
        }
        Valid.checkBoolean(!name.isEmpty(), "Name mustn't be empty");
        this.fileType = fileType;
        this.reloadConsumer = reloadConsumer;
        if (path == null || path.isEmpty()) {
            this.file = new File(FileUtils.replaceExtensions(name) + "." + fileType.getExtension());
        } else {
            String fixedPath = path.replace("\\", "/");
            this.file = new File(fixedPath + File.separator + FileUtils.replaceExtensions(name) + "." + fileType.getExtension());
        }
    }

    protected FlatFile(@NonNull File file, @NonNull FileType fileType) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (fileType == null) {
            throw new NullPointerException("fileType is marked non-null but is null");
        }
        this.file = file;
        this.fileType = fileType;
        this.reloadConsumer = null;
        Valid.checkBoolean(fileType == FileType.fromExtension(file), "Invalid file-extension for file type: '" + (Object)((Object)fileType) + "'", "Extension: '" + FileUtils.getExtension(file) + "'");
    }

    protected FlatFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.file = file;
        this.reloadConsumer = null;
        this.fileType = FileType.fromFile(file);
    }

    protected final boolean create() {
        return this.createFile(this.file);
    }

    private synchronized boolean createFile(File file) {
        if (file.exists()) {
            this.lastLoaded = System.currentTimeMillis();
            return false;
        }
        FileUtils.getAndMake(file);
        this.lastLoaded = System.currentTimeMillis();
        return true;
    }

    protected abstract Map<String, Object> readToMap() throws IOException;

    protected abstract void write(FileData var1) throws IOException;

    protected void handleReloadException(IOException ioException) {
        String fileName = this.fileType == null ? "File" : this.fileType.name().toLowerCase();
        System.err.println("Exception reloading " + fileName + " '" + this.getName() + "'");
        System.err.println("In '" + FileUtils.getParentDirPath(this.file) + "'");
        ioException.printStackTrace();
    }

    @Override
    public synchronized void set(String key, Object value) {
        this.reloadIfNeeded();
        String finalKey = this.pathPrefix == null ? key : this.pathPrefix + "." + key;
        this.fileData.insert(finalKey, value);
        this.write();
        this.lastLoaded = System.currentTimeMillis();
    }

    @Override
    public final Object get(String key) {
        this.reloadIfNeeded();
        String finalKey = this.pathPrefix == null ? key : this.pathPrefix + "." + key;
        return this.getFileData().get(finalKey);
    }

    @Override
    public final boolean contains(String key) {
        this.reloadIfNeeded();
        String finalKey = this.pathPrefix == null ? key : this.pathPrefix + "." + key;
        return this.fileData.containsKey(finalKey);
    }

    @Override
    public final Set<String> singleLayerKeySet() {
        this.reloadIfNeeded();
        return this.fileData.singleLayerKeySet();
    }

    @Override
    public final Set<String> singleLayerKeySet(String key) {
        this.reloadIfNeeded();
        return this.fileData.singleLayerKeySet(key);
    }

    @Override
    public final Set<String> keySet() {
        this.reloadIfNeeded();
        return this.fileData.keySet();
    }

    @Override
    public final Set<String> keySet(String key) {
        this.reloadIfNeeded();
        return this.fileData.keySet(key);
    }

    @Override
    public final synchronized void remove(String key) {
        this.reloadIfNeeded();
        this.fileData.remove(key);
        this.write();
    }

    public final void putAll(Map<String, Object> map) {
        this.fileData.putAll(map);
        this.write();
    }

    public final Map<String, Object> getData() {
        return this.getFileData().toMap();
    }

    public final List<Object> getAll(String ... keys) {
        ArrayList<Object> result = new ArrayList<Object>();
        this.reloadIfNeeded();
        for (String key : keys) {
            result.add(this.get(key));
        }
        return result;
    }

    public void removeAll(String ... keys) {
        for (String key : keys) {
            this.fileData.remove(key);
        }
        this.write();
    }

    public final void addDefaultsFromMap(@NonNull Map<String, Object> mapWithDefaults) {
        if (mapWithDefaults == null) {
            throw new NullPointerException("mapWithDefaults is marked non-null but is null");
        }
        this.addDefaultsFromFileData(new FileData(mapWithDefaults, this.dataType));
    }

    public final void addDefaultsFromFileData(@NonNull FileData newData) {
        if (newData == null) {
            throw new NullPointerException("newData is marked non-null but is null");
        }
        this.reloadIfNeeded();
        for (String key : newData.keySet()) {
            if (this.fileData.containsKey(key)) continue;
            this.fileData.insert(key, newData.get(key));
        }
        this.write();
    }

    public final void addDefaultsFromFlatFile(@NonNull FlatFile flatFile) {
        if (flatFile == null) {
            throw new NullPointerException("flatFile is marked non-null but is null");
        }
        this.addDefaultsFromFileData(flatFile.getFileData());
    }

    public final String getName() {
        return this.file.getName();
    }

    public final String getFilePath() {
        return this.file.getAbsolutePath();
    }

    public synchronized void replace(CharSequence target, CharSequence replacement) throws IOException {
        List<String> lines = Files.readAllLines(this.file.toPath());
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            result.add(line.replace(target, replacement));
        }
        Files.write(this.file.toPath(), result, new OpenOption[0]);
    }

    public void write() {
        try {
            this.write(this.fileData);
        }
        catch (IOException ex) {
            System.err.println("Exception writing to file '" + this.getName() + "'");
            System.err.println("In '" + FileUtils.getParentDirPath(this.file) + "'");
            ex.printStackTrace();
        }
        this.lastLoaded = System.currentTimeMillis();
    }

    public final boolean hasChanged() {
        return FileUtils.hasChanged(this.file, this.lastLoaded);
    }

    public final void forceReload() {
        HashMap<String, Object> out = new HashMap();
        try {
            out = this.readToMap();
        }
        catch (IOException ex) {
            this.handleReloadException(ex);
        }
        finally {
            if (this.fileData == null) {
                this.fileData = new FileData(out, this.dataType);
            } else {
                this.fileData.loadData(out);
            }
            this.lastLoaded = System.currentTimeMillis();
            if (this.reloadConsumer != null) {
                this.reloadConsumer.accept(this);
            }
        }
    }

    public final void clear() {
        this.fileData.clear();
        this.write();
    }

    public final void clearPathPrefix() {
        this.pathPrefix = null;
    }

    protected final void reloadIfNeeded() {
        if (this.reloadSetting.equals((Object)ReloadSetting.MANUALLY)) {
            return;
        }
        if (this.shouldReload()) {
            this.forceReload();
        }
    }

    protected boolean shouldReload() {
        switch (this.reloadSetting) {
            case AUTOMATICALLY: {
                return true;
            }
            case INTELLIGENT: {
                return FileUtils.hasChanged(this.file, this.lastLoaded);
            }
        }
        return false;
    }

    public final FileData getFileData() {
        Valid.notNull(this.fileData, "FileData mustn't be null");
        return this.fileData;
    }

    public final FlatFileSection getSection(String pathPrefix) {
        return new FlatFileSection(this, pathPrefix);
    }

    @Override
    public final int compareTo(@NonNull FlatFile flatFile) {
        if (flatFile == null) {
            throw new NullPointerException("flatFile is marked non-null but is null");
        }
        return this.file.compareTo(flatFile.file);
    }

    public void annotateClass(Object classInstance, String section) {
        this.annotateClass(classInstance, (String s, Field field) -> section + "." + s);
    }

    public void annotateClass(Object classInstance) {
        this.annotateClass(classInstance, (String s, Field field) -> s);
    }

    public void annotateClass(Object classInstance, BiFunction<String, Field, String> elementSelector) {
        Class<?> clazz = classInstance.getClass();
        try {
            for (Field field : clazz.getFields()) {
                ConfigPath configPath = field.getAnnotation(ConfigPath.class);
                if (configPath == null) continue;
                field.setAccessible(true);
                field.set(classInstance, this.get(elementSelector.apply(configPath.value(), field), field.getType()));
            }
        }
        catch (IllegalAccessException e) {
            throw CrateProviders.exceptionHandler().create(e.getCause(), "Unable to set the value of fields in " + clazz.getName());
        }
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public FileType getFileType() {
        return this.fileType;
    }

    @Generated
    public ReloadSetting getReloadSetting() {
        return this.reloadSetting;
    }

    @Generated
    public DataType getDataType() {
        return this.dataType;
    }

    @Nullable
    @Generated
    public Consumer<FlatFile> getReloadConsumer() {
        return this.reloadConsumer;
    }

    @Generated
    public String getPathPrefix() {
        return this.pathPrefix;
    }

    @Generated
    public long getLastLoaded() {
        return this.lastLoaded;
    }

    @Generated
    public String toString() {
        return "FlatFile(file=" + this.getFile() + ", fileType=" + (Object)((Object)this.getFileType()) + ", reloadSetting=" + (Object)((Object)this.getReloadSetting()) + ", dataType=" + (Object)((Object)this.getDataType()) + ", fileData=" + this.getFileData() + ", reloadConsumer=" + this.getReloadConsumer() + ", pathPrefix=" + this.getPathPrefix() + ", lastLoaded=" + this.getLastLoaded() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlatFile)) {
            return false;
        }
        FlatFile other = (FlatFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLastLoaded() != other.getLastLoaded()) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        FileType this$fileType = this.getFileType();
        FileType other$fileType = other.getFileType();
        if (this$fileType == null ? other$fileType != null : !((Object)((Object)this$fileType)).equals((Object)other$fileType)) {
            return false;
        }
        ReloadSetting this$reloadSetting = this.getReloadSetting();
        ReloadSetting other$reloadSetting = other.getReloadSetting();
        if (this$reloadSetting == null ? other$reloadSetting != null : !((Object)((Object)this$reloadSetting)).equals((Object)other$reloadSetting)) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType)) {
            return false;
        }
        FileData this$fileData = this.getFileData();
        FileData other$fileData = other.getFileData();
        if (this$fileData == null ? other$fileData != null : !((Object)this$fileData).equals(other$fileData)) {
            return false;
        }
        Consumer<FlatFile> this$reloadConsumer = this.getReloadConsumer();
        Consumer<FlatFile> other$reloadConsumer = other.getReloadConsumer();
        if (this$reloadConsumer == null ? other$reloadConsumer != null : !this$reloadConsumer.equals(other$reloadConsumer)) {
            return false;
        }
        String this$pathPrefix = this.getPathPrefix();
        String other$pathPrefix = other.getPathPrefix();
        return !(this$pathPrefix == null ? other$pathPrefix != null : !this$pathPrefix.equals(other$pathPrefix));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlatFile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastLoaded = this.getLastLoaded();
        result = result * 59 + (int)($lastLoaded >>> 32 ^ $lastLoaded);
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        FileType $fileType = this.getFileType();
        result = result * 59 + ($fileType == null ? 43 : ((Object)((Object)$fileType)).hashCode());
        ReloadSetting $reloadSetting = this.getReloadSetting();
        result = result * 59 + ($reloadSetting == null ? 43 : ((Object)((Object)$reloadSetting)).hashCode());
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        FileData $fileData = this.getFileData();
        result = result * 59 + ($fileData == null ? 43 : ((Object)$fileData).hashCode());
        Consumer<FlatFile> $reloadConsumer = this.getReloadConsumer();
        result = result * 59 + ($reloadConsumer == null ? 43 : $reloadConsumer.hashCode());
        String $pathPrefix = this.getPathPrefix();
        result = result * 59 + ($pathPrefix == null ? 43 : $pathPrefix.hashCode());
        return result;
    }

    @Generated
    public void setReloadSetting(ReloadSetting reloadSetting) {
        this.reloadSetting = reloadSetting;
    }

    @Generated
    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }
}

