/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.crate.internal.serialize;

import io.github.milkdrinkers.crate.internal.serialize.CrateSerializable;
import io.github.milkdrinkers.crate.util.Valid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class CrateSerializer {
    private static final List<CrateSerializable<?>> serializables = Collections.synchronizedList(new ArrayList());

    public static boolean isSerializable(Class<?> clazz) {
        return CrateSerializer.findSerializable(clazz) != null;
    }

    public static void registerSerializable(@NonNull CrateSerializable<?> serializable) {
        if (serializable == null) {
            throw new NullPointerException("serializable is marked non-null but is null");
        }
        Valid.notNull(serializable.getClazz(), "Class of serializable mustn't be null");
        serializables.add(serializable);
    }

    @Nullable
    public static CrateSerializable<?> findSerializable(Class<?> clazz) {
        for (CrateSerializable<?> serializable : serializables) {
            if (!serializable.getClazz().equals(clazz)) continue;
            return serializable;
        }
        return null;
    }

    public static Object serialize(Object obj) {
        CrateSerializable<?> serializable = CrateSerializer.findSerializable(obj.getClass());
        Valid.notNull(serializable, "No serializable found for '" + obj.getClass().getSimpleName() + "'");
        return serializable.serialize(obj);
    }

    public static <T> T deserialize(Object raw, Class<T> type, String key) {
        CrateSerializable<?> serializable = CrateSerializer.findSerializable(type);
        Valid.notNull(serializable, "No serializable found for '" + type.getSimpleName() + "'", "Raw: '" + raw.getClass().getSimpleName() + "'");
        return (T)serializable.deserialize(raw, key.substring(key.lastIndexOf(".") + 1));
    }

    @Generated
    private CrateSerializer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

