/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.javasemver;

import io.github.milkdrinkers.javasemver.VersionBuilder;
import io.github.milkdrinkers.javasemver.VersionCheckResult;
import io.github.milkdrinkers.javasemver.VersionCompare;
import io.github.milkdrinkers.javasemver.VersionParser;
import io.github.milkdrinkers.javasemver.exception.VersionBuildException;
import io.github.milkdrinkers.javasemver.exception.VersionParseException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class Version
extends VersionCompare
implements Comparable<Version> {
    private final long major;
    private final long minor;
    private final long patch;
    private final String preRelease;
    private final String[] preReleaseIdentifiers;
    private final String meta;
    private final boolean hasPreRelease;
    private final boolean hasMeta;
    private final String version;
    private final String versionFull;
    private final boolean isAlpha;
    private final boolean isBeta;
    private final boolean isDevelopment;
    private final boolean isReleaseCandidate;
    private final boolean isSnapshot;

    @ApiStatus.Internal
    Version(long major, long minor, long patch, String preRelease, String meta) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.preReleaseIdentifiers = (String[])Arrays.stream(preRelease.split("\\.")).filter(string -> !string.isEmpty()).toArray(String[]::new);
        this.meta = meta;
        this.hasPreRelease = !this.getPreRelease().isEmpty();
        this.hasMeta = !this.getBuildMetadata().isEmpty();
        this.version = Version.concatenateVersionString(this.major, this.minor, this.patch);
        this.versionFull = Version.concatenateVersionStringFull(this.major, this.minor, this.patch, this.preRelease, this.meta);
        this.isAlpha = preRelease.toLowerCase().contains("alpha");
        this.isBeta = preRelease.toLowerCase().contains("beta");
        this.isDevelopment = preRelease.toLowerCase().contains("dev") || preRelease.toLowerCase().contains("develop") || preRelease.toLowerCase().contains("development");
        this.isReleaseCandidate = preRelease.toLowerCase().contains("rc");
        this.isSnapshot = preRelease.toLowerCase().contains("snapshot");
    }

    @NotNull
    public static Version of(String version) throws VersionParseException {
        return VersionParser.parse(version);
    }

    @NotNull
    public static Optional<Version> ofOptional(String version) {
        try {
            return Optional.of(VersionParser.parse(version));
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    @NotNull
    public static Version of(long major, long minor, long patch) throws VersionBuildException {
        return Version.of(major, minor, patch, "");
    }

    @NotNull
    public static Version of(long major, long minor, long patch, String preRelease) throws VersionBuildException {
        return Version.of(major, minor, patch, preRelease, "");
    }

    @NotNull
    public static Version of(long major, long minor, long patch, String preRelease, String meta) throws VersionBuildException {
        return new VersionBuilder().withMajor(major).withMinor(minor).withPatch(patch).withPreRelease(preRelease).withMeta(meta).build();
    }

    public long getMajor() {
        return this.major;
    }

    public long getMinor() {
        return this.minor;
    }

    public long getPatch() {
        return this.patch;
    }

    public String getPreRelease() {
        return this.preRelease;
    }

    public String[] getPreReleaseIdentifiers() {
        return this.preReleaseIdentifiers;
    }

    public String getBuildMetadata() {
        return this.meta;
    }

    public boolean hasPreRelease() {
        return this.hasPreRelease;
    }

    public boolean hasMeta() {
        return this.hasMeta;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionFull() {
        return this.versionFull;
    }

    public boolean isAlpha() {
        return this.isAlpha;
    }

    public boolean isBeta() {
        return this.isBeta;
    }

    public boolean isDev() {
        return this.isDevelopment;
    }

    public boolean isRC() {
        return this.isReleaseCandidate;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    private static String concatenateVersionString(long major, long minor, long patch) {
        return String.format("%s.%s.%s", major, minor, patch);
    }

    private static String concatenateVersionStringFull(long major, long minor, long patch, String preRelease, String meta) {
        return String.format("%s%s%s", Version.concatenateVersionString(major, minor, patch), preRelease.isEmpty() ? "" : "-" + preRelease, meta.isEmpty() ? "" : "+" + meta);
    }

    @Override
    public int compareTo(@NotNull Version other) {
        VersionCheckResult result = VersionCompare.compare(this, other);
        switch (result) {
            case NEWER: {
                return -1;
            }
            case OLDER: {
                return 1;
            }
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return this.getMajor() == version.getMajor() && this.getMinor() == version.getMinor() && this.getPatch() == version.getPatch() && Objects.equals(this.hasPreRelease(), version.hasPreRelease()) && Objects.equals(this.getBuildMetadata(), version.getBuildMetadata());
    }

    public int hashCode() {
        return Objects.hash(this.getMajor(), this.getMinor(), this.getPatch(), this.hasPreRelease(), this.getBuildMetadata());
    }

    public String toString() {
        return this.getVersionFull();
    }
}

