/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.javasemver;

import io.github.milkdrinkers.javasemver.Version;
import io.github.milkdrinkers.javasemver.exception.VersionBuildException;

public final class VersionBuilder {
    private Long major;
    private Long minor;
    private Long patch;
    private String preRelease;
    private String meta;

    public VersionBuilder withMajor(long major) {
        this.major = major;
        return this;
    }

    public VersionBuilder withMinor(long minor) {
        this.minor = minor;
        return this;
    }

    public VersionBuilder withPatch(long patch) {
        this.patch = patch;
        return this;
    }

    public VersionBuilder withPreRelease(String preRelease) {
        this.preRelease = preRelease;
        return this;
    }

    public VersionBuilder withMeta(String meta) {
        this.meta = meta;
        return this;
    }

    public Version build() throws VersionBuildException {
        if (this.major == null) {
            throw new VersionBuildException("Major version needs to be specified.");
        }
        if (this.minor == null) {
            throw new VersionBuildException("Minor version needs to be specified.");
        }
        if (this.patch == null) {
            throw new VersionBuildException("Patch version needs to be specified.");
        }
        if (this.major < 0L) {
            throw new VersionBuildException(String.format("Major version \"%s\" can't be less than 0.", this.major));
        }
        if (this.minor < 0L) {
            throw new VersionBuildException(String.format("Minor version \"%s\" can't be less than 0.", this.minor));
        }
        if (this.patch < 0L) {
            throw new VersionBuildException(String.format("Patch version \"%s\" can't be less than 0.", this.patch));
        }
        if (this.preRelease == null) {
            this.preRelease = "";
        }
        if (this.meta == null) {
            this.meta = "";
        }
        return new Version(this.major, this.minor, this.patch, this.preRelease, this.meta);
    }
}

