/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.javasemver;

import io.github.milkdrinkers.javasemver.Version;
import io.github.milkdrinkers.javasemver.VersionCheckResult;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VersionCompare {
    @ApiStatus.Internal
    private static VersionCheckResult result(long result) {
        if ((double)result == 0.0) {
            return VersionCheckResult.EQUAL;
        }
        return (double)result < 0.0 ? VersionCheckResult.OLDER : VersionCheckResult.NEWER;
    }

    @NotNull
    public static VersionCheckResult compare(@NotNull Version current, @NotNull Version other) {
        long majorChange = current.getMajor() - other.getMajor();
        long minorChange = current.getMinor() - other.getMinor();
        long patchChange = current.getPatch() - other.getPatch();
        if (majorChange != 0L) {
            return VersionCompare.result(majorChange);
        }
        if (minorChange != 0L) {
            return VersionCompare.result(minorChange);
        }
        if (patchChange != 0L) {
            return VersionCompare.result(patchChange);
        }
        return VersionCompare.comparePreRelease(current, other);
    }

    @NotNull
    public static VersionCheckResult comparePreRelease(@NotNull Version current, @NotNull Version other) {
        String[] currentIdentifiers = current.getPreReleaseIdentifiers();
        String[] otherIdentifiers = other.getPreReleaseIdentifiers();
        if (currentIdentifiers == null || currentIdentifiers.length == 0) {
            if (otherIdentifiers == null || otherIdentifiers.length == 0) {
                return VersionCheckResult.EQUAL;
            }
            return VersionCheckResult.NEWER;
        }
        if (otherIdentifiers == null || otherIdentifiers.length == 0) {
            return VersionCheckResult.OLDER;
        }
        int minLength = Math.min(currentIdentifiers.length, otherIdentifiers.length);
        for (int i = 0; i < minLength; ++i) {
            String currentId = currentIdentifiers[i];
            String otherId = otherIdentifiers[i];
            boolean isCurrentNumeric = VersionCompare.isNumeric(currentId);
            boolean isOtherNumeric = VersionCompare.isNumeric(otherId);
            if (isCurrentNumeric && !isOtherNumeric) {
                return VersionCheckResult.OLDER;
            }
            if (!isCurrentNumeric && isOtherNumeric) {
                return VersionCheckResult.NEWER;
            }
            if (isCurrentNumeric && isOtherNumeric) {
                int num2;
                int num1 = Integer.parseInt(currentId);
                if (num1 < (num2 = Integer.parseInt(otherId))) {
                    return VersionCheckResult.OLDER;
                }
                if (num1 <= num2) continue;
                return VersionCheckResult.NEWER;
            }
            int comparison = currentId.compareTo(otherId);
            if (comparison < 0) {
                return VersionCheckResult.OLDER;
            }
            if (comparison <= 0) continue;
            return VersionCheckResult.NEWER;
        }
        if (currentIdentifiers.length < otherIdentifiers.length) {
            return VersionCheckResult.OLDER;
        }
        if (currentIdentifiers.length > otherIdentifiers.length) {
            return VersionCheckResult.NEWER;
        }
        return VersionCheckResult.EQUAL;
    }

    private static boolean isNumeric(@Nullable String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return false;
        }
        if (!identifier.matches("\\d+")) {
            return false;
        }
        return identifier.length() <= 1 || !identifier.startsWith("0");
    }

    public static boolean isEqual(@NotNull Version current, @NotNull Version other) {
        return VersionCompare.compare(current, other).equals((Object)VersionCheckResult.EQUAL);
    }

    public static boolean isNewer(@NotNull Version current, @NotNull Version other) {
        return VersionCompare.compare(current, other).equals((Object)VersionCheckResult.NEWER);
    }

    public static boolean isOlder(@NotNull Version current, @NotNull Version other) {
        return VersionCompare.compare(current, other).equals((Object)VersionCheckResult.OLDER);
    }

    public static boolean isNewerOrEqual(@NotNull Version current, @NotNull Version other) {
        return VersionCompare.isNewer(current, other) || VersionCompare.isEqual(current, other);
    }

    public static boolean isOlderOrEqual(@NotNull Version current, @NotNull Version other) {
        return VersionCompare.isOlder(current, other) || VersionCompare.isEqual(current, other);
    }
}

