/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.javasemver;

import io.github.milkdrinkers.javasemver.Version;
import io.github.milkdrinkers.javasemver.VersionBuilder;
import io.github.milkdrinkers.javasemver.exception.VersionBuildException;
import io.github.milkdrinkers.javasemver.exception.VersionParseException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class VersionParser {
    private static final Pattern SEMVER_REGEX = Pattern.compile("^(?<major>0|[1-9]\\d*)\\.(?<minor>0|[1-9]\\d*)\\.(?<patch>0|[1-9]\\d*)(?:-(?<prerelease>(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+(?<meta>[0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");

    public static Version parse(String unparsedVersion) throws VersionParseException {
        if (unparsedVersion.length() < 5) {
            throw new VersionParseException(String.format("Version could not be parsed from version string \"%s\".", unparsedVersion));
        }
        if (unparsedVersion.toUpperCase().startsWith("V")) {
            unparsedVersion = unparsedVersion.substring(1);
        }
        try {
            Matcher matcher = SEMVER_REGEX.matcher(unparsedVersion);
            if (!matcher.matches()) {
                throw new VersionParseException(String.format("Version could not be parsed from version string \"%s\".", unparsedVersion));
            }
            Optional<Long> major = Optional.ofNullable(matcher.group("major")).map(Long::parseLong);
            Optional<Long> minor = Optional.ofNullable(matcher.group("minor")).map(Long::parseLong);
            Optional<Long> patch = Optional.ofNullable(matcher.group("patch")).map(Long::parseLong);
            Optional<String> preRelease = Optional.ofNullable(matcher.group("prerelease"));
            Optional<String> meta = Optional.ofNullable(matcher.group("meta"));
            if (!major.isPresent()) {
                throw new VersionParseException(String.format("Major version could not be parsed from version string \"%s\" when constructing Version object.", unparsedVersion));
            }
            if (!minor.isPresent()) {
                throw new VersionParseException(String.format("Minor version could not be parsed from version string \"%s\" when constructing Version object.", unparsedVersion));
            }
            if (!patch.isPresent()) {
                throw new VersionParseException(String.format("Patch version could not be parsed from version string \"%s\" when constructing Version object.", unparsedVersion));
            }
            return new VersionBuilder().withMajor(major.get()).withMinor(minor.get()).withPatch(patch.get()).withPreRelease(preRelease.orElse("")).withMeta(meta.orElse("")).build();
        }
        catch (IllegalStateException e) {
            throw new VersionParseException(String.format("Match operation failed parsing version from string \"%s\" when constructing Version object.", unparsedVersion));
        }
        catch (IllegalArgumentException e) {
            throw new VersionParseException(String.format("Regex groups were not found while parsing version from string \"%s\" when constructing Version object.", unparsedVersion));
        }
        catch (VersionBuildException e) {
            throw new VersionParseException(String.format("Builder failed while parsing version from string \"%s\" when constructing Version object.", unparsedVersion), e);
        }
    }
}

