/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.threadutil;

import io.github.milkdrinkers.threadutil.PlatformAdapter;
import io.github.milkdrinkers.threadutil.exception.SchedulerShutdownTimeoutException;
import io.github.milkdrinkers.threadutil.internal.ExecutorService;
import io.github.milkdrinkers.threadutil.internal.ExecutorServiceBuilder;
import java.time.Duration;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class PlatformBukkit
implements PlatformAdapter {
    private final Plugin plugin;
    private final ExecutorService executorService;

    public PlatformBukkit(Plugin plugin) {
        this.plugin = plugin;
        this.executorService = new ExecutorServiceBuilder().setImplementationName(plugin.getName()).build();
    }

    public boolean isMainThread() {
        return Bukkit.isPrimaryThread();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void runSync(Runnable runnable) {
        if (this.plugin.isEnabled()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, runnable);
        } else {
            runnable.run();
        }
    }

    public void runAsync(Runnable runnable) {
        super.runAsync(runnable);
    }

    public void runSyncLater(long ticks, Runnable runnable) {
        if (this.plugin.isEnabled()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, runnable, ticks);
        } else {
            runnable.run();
        }
    }

    public void runSyncLater(Duration duration, Runnable runnable) {
        this.runSyncLater(this.toTicks(duration), runnable);
    }

    public void shutdown(Duration duration) throws SchedulerShutdownTimeoutException {
        super.shutdown(duration);
    }

    public long toTicks(Duration duration) {
        return (duration.toMillis() + 49L) / 50L;
    }

    public Duration fromTicks(long ticks) {
        return Duration.ofMillis(ticks * 50L);
    }
}

