/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.wordweaver;

import io.github.milkdrinkers.wordweaver.TranslationProvider;
import io.github.milkdrinkers.wordweaver.config.TranslationConfig;
import io.github.milkdrinkers.wordweaver.loader.impl.JsonTranslationLoader;
import io.github.milkdrinkers.wordweaver.service.impl.TranslationServiceImpl;
import io.github.milkdrinkers.wordweaver.storage.impl.LanguageRegistryImpl;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Translation {
    private static final Logger LOGGER = LoggerFactory.getLogger(Translation.class);

    private Translation() {
    }

    public static String of(String key) {
        return Translation.of(key, null);
    }

    public static String of(String key, String fallback) {
        return TranslationProvider.getInstance().getTranslationService().getString(key, fallback);
    }

    public static List<String> ofList(String key) {
        return Translation.ofList(key, null);
    }

    public static List<String> ofList(String key, @Nullable List<String> fallback) {
        return TranslationProvider.getInstance().getTranslationService().getStringList(key, fallback != null ? fallback : Collections.emptyList());
    }

    public static Component as(String key) {
        return Translation.as(key, null);
    }

    public static Component as(String key, Component fallback) {
        return TranslationProvider.getInstance().getTranslationService().getComponent(key, fallback);
    }

    public static List<Component> asList(String key) {
        return Translation.asList(key, null);
    }

    public static List<Component> asList(String key, @Nullable List<Component> fallback) {
        return TranslationProvider.getInstance().getTranslationService().getComponentList(key, fallback != null ? fallback : Collections.emptyList());
    }

    public static Set<String> getKeys() {
        return TranslationProvider.getInstance().getTranslationService().getKeys();
    }

    public static void setDefaultLanguage(@NotNull String language) {
        TranslationProvider.getInstance().getTranslationService().setDefaultLanguage(language);
    }

    public static String getDefaultLanguage() {
        return TranslationProvider.getInstance().getTranslationService().getDefaultLanguage();
    }

    public static void setLanguage(@NotNull String language) {
        TranslationProvider.getInstance().getTranslationService().setLanguage(language);
    }

    public static String getLanguage() {
        return TranslationProvider.getInstance().getTranslationService().getLanguage();
    }

    public static void initialize(@NotNull TranslationConfig config) {
        LanguageRegistryImpl registry = new LanguageRegistryImpl(config);
        JsonTranslationLoader loader = new JsonTranslationLoader(config, registry);
        TranslationServiceImpl service = new TranslationServiceImpl(config, registry, loader);
        TranslationProvider.initialize(service);
        LOGGER.debug("Initialized WordWeaver with current language: {}, and fallback language: {}", (Object)config.getCurrentLanguage(), (Object)config.getDefaultLanguage());
    }

    public static void reload() {
        TranslationProvider.getInstance().getTranslationService().reload();
    }

    static {
        if (LOGGER.getClass().getName().contains("NOPLogger")) {
            System.err.println("No SLF4J implementation found for WordWeaver. \nConsider adding an SLF4J compatible logging implementation to your project.");
        }
    }
}

