/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.wordweaver;

import io.github.milkdrinkers.wordweaver.service.TranslationService;

public final class TranslationProvider {
    private static TranslationProvider INSTANCE;
    private final TranslationService translationService;

    private TranslationProvider(TranslationService service) {
        this.translationService = service;
    }

    static TranslationProvider getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Translation provider has not been initialized");
        }
        return INSTANCE;
    }

    static synchronized void initialize(TranslationService service) {
        if (INSTANCE != null) {
            throw new IllegalStateException("Translation provider already initialized");
        }
        INSTANCE = new TranslationProvider(service);
    }

    TranslationService getTranslationService() {
        return this.translationService;
    }
}

