/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.wordweaver.config;

import io.github.milkdrinkers.wordweaver.MissingTranslationHandler;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import net.kyori.adventure.text.Component;

public class TranslationConfig {
    public static final String DEFAULT_LANG = "en_US";
    private Path languagesDirectory = null;
    private String defaultLanguage;
    private String currentLanguage = this.defaultLanguage = "en_US";
    private Path resourcesDirectory = Paths.get("lang", new String[0]);
    private boolean extractLanguages = true;
    private boolean updateLanguages = true;
    private MissingTranslationHandler missingTranslationHandler = MissingTranslationHandler.DEFAULT;
    private Function<String, Component> componentConverter = Component::text;

    private TranslationConfig() {
    }

    public Path getLanguagesDirectory() {
        return this.languagesDirectory;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public void setCurrentLanguage(String currentLanguage) {
        this.currentLanguage = currentLanguage;
    }

    public Path getResourcesDirectory() {
        return this.resourcesDirectory;
    }

    public boolean shouldExtractLanguages() {
        return this.extractLanguages;
    }

    public boolean shouldUpdateLanguages() {
        return this.updateLanguages;
    }

    public MissingTranslationHandler getMissingTranslationHandler() {
        return this.missingTranslationHandler;
    }

    public Function<String, Component> getComponentConverter() {
        return this.componentConverter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final TranslationConfig config = new TranslationConfig();

        private Builder() {
        }

        public Builder translationDirectory(Path directory) {
            this.config.languagesDirectory = directory;
            return this;
        }

        public Builder defaultLanguage(String language) {
            this.config.defaultLanguage = language;
            return this;
        }

        public Builder language(String language) {
            this.config.currentLanguage = language;
            return this;
        }

        public Builder resourcesDirectory(Path path) {
            this.config.resourcesDirectory = path;
            return this;
        }

        public Builder extractLanguages(boolean extract) {
            this.config.extractLanguages = extract;
            return this;
        }

        public Builder updateLanguages(boolean update) {
            this.config.updateLanguages = update;
            return this;
        }

        public Builder missingTranslationHandler(MissingTranslationHandler handler) {
            this.config.missingTranslationHandler = handler;
            return this;
        }

        public Builder componentConverter(Function<String, Component> converter) {
            this.config.componentConverter = converter;
            return this;
        }

        public TranslationConfig build() {
            if (this.config.languagesDirectory == null) {
                throw new IllegalStateException("Translation directory must be set");
            }
            if (this.config.defaultLanguage == null || this.config.defaultLanguage.isEmpty()) {
                this.config.defaultLanguage = TranslationConfig.DEFAULT_LANG;
            }
            if (this.config.currentLanguage == null || this.config.currentLanguage.isEmpty()) {
                this.config.currentLanguage = this.config.defaultLanguage;
            }
            if (this.config.resourcesDirectory == null) {
                this.config.resourcesDirectory = Paths.get("lang", new String[0]);
            }
            if (this.config.resourcesDirectory.isAbsolute()) {
                throw new IllegalStateException("Resources directory must be relative");
            }
            if (this.config.missingTranslationHandler == null) {
                this.config.missingTranslationHandler = MissingTranslationHandler.DEFAULT;
            }
            if (this.config.componentConverter == null) {
                this.config.componentConverter = Component::text;
            }
            return this.config;
        }
    }
}

