/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.wordweaver.lib.gson;

import io.github.milkdrinkers.wordweaver.lib.errorprone.annotations.InlineMe;
import io.github.milkdrinkers.wordweaver.lib.gson.JsonElement;
import io.github.milkdrinkers.wordweaver.lib.gson.JsonIOException;
import io.github.milkdrinkers.wordweaver.lib.gson.JsonParseException;
import io.github.milkdrinkers.wordweaver.lib.gson.JsonSyntaxException;
import io.github.milkdrinkers.wordweaver.lib.gson.Strictness;
import io.github.milkdrinkers.wordweaver.lib.gson.internal.Streams;
import io.github.milkdrinkers.wordweaver.lib.gson.stream.JsonReader;
import io.github.milkdrinkers.wordweaver.lib.gson.stream.JsonToken;
import io.github.milkdrinkers.wordweaver.lib.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class JsonParser {
    @Deprecated
    public JsonParser() {
    }

    public static JsonElement parseString(String json) throws JsonSyntaxException {
        return JsonParser.parseReader(new StringReader(json));
    }

    public static JsonElement parseReader(Reader reader) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            JsonElement element = JsonParser.parseReader(jsonReader);
            if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return element;
        }
        catch (MalformedJsonException | NumberFormatException e) {
            throw new JsonSyntaxException(e);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    public static JsonElement parseReader(JsonReader reader) throws JsonIOException, JsonSyntaxException {
        Strictness strictness = reader.getStrictness();
        if (strictness == Strictness.LEGACY_STRICT) {
            reader.setStrictness(Strictness.LENIENT);
        }
        try {
            JsonElement jsonElement = Streams.parse(reader);
            return jsonElement;
        }
        catch (OutOfMemoryError | StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source: " + reader + " to Json", e);
        }
        finally {
            reader.setStrictness(strictness);
        }
    }

    @Deprecated
    @InlineMe(replacement="JsonParser.parseString(json)", imports={"io.github.milkdrinkers.wordweaver.lib.gson.JsonParser"})
    public JsonElement parse(String json) throws JsonSyntaxException {
        return JsonParser.parseString(json);
    }

    @Deprecated
    @InlineMe(replacement="JsonParser.parseReader(json)", imports={"io.github.milkdrinkers.wordweaver.lib.gson.JsonParser"})
    public JsonElement parse(Reader json) throws JsonIOException, JsonSyntaxException {
        return JsonParser.parseReader(json);
    }

    @Deprecated
    @InlineMe(replacement="JsonParser.parseReader(json)", imports={"io.github.milkdrinkers.wordweaver.lib.gson.JsonParser"})
    public JsonElement parse(JsonReader json) throws JsonIOException, JsonSyntaxException {
        return JsonParser.parseReader(json);
    }
}

