/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.wordweaver.loader.impl;

import io.github.milkdrinkers.wordweaver.Translation;
import io.github.milkdrinkers.wordweaver.lib.gson.JsonElement;
import io.github.milkdrinkers.wordweaver.lib.gson.JsonObject;
import io.github.milkdrinkers.wordweaver.lib.gson.JsonParser;
import io.github.milkdrinkers.wordweaver.loader.impl.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

final class FileExtractor {
    private static ClassLoader CLASS_LOADER = FileExtractor.class.getClassLoader();

    private FileExtractor() {
    }

    public static List<Path> extractJsonResources(Path outputDir, Path resourceDir) throws IOException {
        if (!Files.exists(outputDir, new LinkOption[0])) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        if (resourceDir.isAbsolute()) {
            throw new IOException("The resource directory must be relative");
        }
        ArrayList<Path> extractedFiles = new ArrayList<Path>();
        List<Path> resourceFiles = FileExtractor.findJsonResourceFiles(resourceDir);
        for (Path resourcePath : resourceFiles) {
            String fileName = resourcePath.getFileName().toString();
            Path targetFile = outputDir.resolve(fileName);
            if (!Files.notExists(targetFile, new LinkOption[0])) continue;
            FileExtractor.extractResourceFile(resourcePath, targetFile);
            extractedFiles.add(targetFile);
        }
        return extractedFiles;
    }

    private static List<Path> findJsonResourceFiles(Path resourceDir) throws IOException {
        ArrayList<Path> resources = new ArrayList<Path>();
        URL resourceUrl = CLASS_LOADER.getResource(resourceDir.toString());
        if (resourceUrl == null) {
            return resources;
        }
        if (resourceUrl.getProtocol().equals("jar")) {
            resources.addAll(FileExtractor.findResourcesInJar(resourceDir));
        } else {
            resources.addAll(FileExtractor.findResourcesInFileSystem(resourceDir));
        }
        return resources;
    }

    private static List<Path> findResourcesInJar(Path resourceDir) throws IOException {
        String jarPath;
        ArrayList<Path> resources = new ArrayList<Path>();
        try {
            jarPath = Translation.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to get JAR path", e);
        }
        try (JarFile jar = new JarFile(jarPath);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory() || !entryName.startsWith(resourceDir.toString()) || !entryName.endsWith(".json") && !entryName.endsWith(".jsonc")) continue;
                resources.add(Paths.get(entryName, new String[0]));
            }
        }
        return resources;
    }

    private static List<Path> findResourcesInFileSystem(Path resourceDir) throws IOException {
        ArrayList<Path> resources = new ArrayList<Path>();
        try {
            URL url = CLASS_LOADER.getResource(resourceDir.toString());
            assert (url != null);
            URI uri = url.toURI();
            Path resourcesPath = Paths.get(uri);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(resourcesPath, path -> path.toString().endsWith(".json") || path.toString().endsWith(".jsonc"));){
                for (Path path2 : stream) {
                    resources.add(resourceDir.resolve(path2.getFileName()));
                }
            }
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to get resource directory", e);
        }
        return resources;
    }

    private static void extractResourceFile(Path resourcePath, Path targetFile) throws IOException {
        try (InputStream inputStream = CLASS_LOADER.getResourceAsStream(resourcePath.toString().replace("\\", "/"));){
            if (inputStream == null) {
                throw new IOException("Resource not found while extracting: " + resourcePath);
            }
            Files.copy(inputStream, targetFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void updateFiles(Path outputDir, Path resourceDir) throws IOException {
        if (!Files.exists(outputDir, new LinkOption[0])) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        if (resourceDir.isAbsolute()) {
            throw new IOException("The resource directory must be relative");
        }
        List<Path> resourceFiles = FileExtractor.findJsonResourceFiles(resourceDir);
        for (Path resourcePath : resourceFiles) {
            String fileName = resourcePath.getFileName().toString();
            Path targetFile = outputDir.resolve(fileName);
            if (!Files.exists(targetFile, new LinkOption[0])) continue;
            FileExtractor.mergeJsonFiles(resourceDir.resolve(fileName), targetFile);
        }
    }

    private static void mergeJsonFiles(Path originPath, Path targetPath) throws IOException {
        InputStream originStream = CLASS_LOADER.getResourceAsStream(originPath.toString().replace("\\", "/"));
        if (originStream == null) {
            throw new IOException("Resource not found when merging: " + originPath);
        }
        InputStreamReader originReader = new InputStreamReader(originStream);
        String targetContent = new String(Files.readAllBytes(targetPath));
        JsonObject originJson = JsonParser.parseReader(originReader).getAsJsonObject();
        JsonObject targetJson = JsonParser.parseString(targetContent).getAsJsonObject();
        JsonObject mergedJson = FileExtractor.mergeJsonObjects(originJson, targetJson);
        Files.write(targetPath, FileReader.GSON.toJson(mergedJson).getBytes(), new OpenOption[0]);
    }

    private static JsonObject mergeJsonObjects(JsonObject origin, JsonObject target) {
        String key;
        HashSet<String> processedKeys = new HashSet<String>();
        JsonObject result = new JsonObject();
        for (Map.Entry<String, JsonElement> entry : origin.entrySet()) {
            key = entry.getKey();
            processedKeys.add(key);
            if (target.has(key)) {
                JsonElement originValue = entry.getValue();
                JsonElement targetValue = target.get(key);
                if (originValue.isJsonObject() && targetValue.isJsonObject()) {
                    result.add(key, FileExtractor.mergeJsonObjects(originValue.getAsJsonObject(), targetValue.getAsJsonObject()));
                    continue;
                }
                result.add(key, targetValue);
                continue;
            }
            result.add(key, entry.getValue());
        }
        for (Map.Entry<String, JsonElement> entry : target.entrySet()) {
            key = entry.getKey();
            if (processedKeys.contains(key)) continue;
            result.add(key, entry.getValue());
        }
        return result;
    }
}

