/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.wordweaver.loader.impl;

import io.github.milkdrinkers.wordweaver.lib.gson.Gson;
import io.github.milkdrinkers.wordweaver.lib.gson.GsonBuilder;
import io.github.milkdrinkers.wordweaver.lib.gson.JsonArray;
import io.github.milkdrinkers.wordweaver.lib.gson.JsonElement;
import io.github.milkdrinkers.wordweaver.lib.gson.JsonObject;
import io.github.milkdrinkers.wordweaver.lib.gson.JsonPrimitive;
import io.github.milkdrinkers.wordweaver.lib.gson.Strictness;
import io.github.milkdrinkers.wordweaver.storage.LanguageEntry;
import io.github.milkdrinkers.wordweaver.storage.LanguageLoadException;
import io.github.milkdrinkers.wordweaver.storage.impl.LanguageEntryImpl;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class FileReader {
    static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setStrictness(Strictness.LENIENT).create();

    FileReader() {
    }

    public static Map<String, LanguageEntry> readFile(String path) throws LanguageLoadException {
        return FileReader.readFile(new File(path));
    }

    public static Map<String, LanguageEntry> readFile(Path path) throws LanguageLoadException {
        return FileReader.readFile(path.toFile());
    }

    /*
     * Exception decompiling
     */
    public static Map<String, LanguageEntry> readFile(File file) throws LanguageLoadException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<String, LanguageEntry> flatten(JsonObject jsonObject) {
        HashMap<String, LanguageEntry> translationMap = new HashMap<String, LanguageEntry>();
        if (jsonObject.isJsonNull()) {
            return translationMap;
        }
        FileReader.flattenJsonElement("", jsonObject, translationMap);
        return translationMap;
    }

    private static void flattenJsonElement(String currentPath, JsonElement element, Map<String, LanguageEntry> translationMap) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = element.getAsJsonPrimitive();
            translationMap.put(currentPath, new LanguageEntryImpl(LanguageEntry.Type.STRING, jsonPrimitive.getAsString()));
        } else if (element.isJsonObject()) {
            FileReader.flattenObject(currentPath, element, translationMap);
        } else if (element.isJsonArray()) {
            FileReader.flattenArray(currentPath, element, translationMap);
        } else if (element.isJsonNull()) {
            translationMap.put(currentPath, new LanguageEntryImpl(LanguageEntry.Type.STRING, ""));
        }
    }

    private static void flattenObject(String currentPath, JsonElement element, Map<String, LanguageEntry> translationMap) {
        JsonObject jsonObject = element.getAsJsonObject();
        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            String internalPath = currentPath.isEmpty() ? entry.getKey() : String.format("%s.%s", currentPath, entry.getKey());
            FileReader.flattenJsonElement(internalPath, entry.getValue(), translationMap);
        }
    }

    private static void flattenArray(String currentPath, JsonElement element, Map<String, LanguageEntry> translationMap) {
        JsonArray jsonArray = element.getAsJsonArray();
        ArrayList<String> arrayValues = new ArrayList<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonElement arrayElement = jsonArray.get(i);
            String internalPath = String.format("%s.%d", currentPath, i + 1);
            if (arrayElement.isJsonPrimitive()) {
                String arrayValue = arrayElement.getAsString();
                arrayValues.add(arrayValue);
                translationMap.put(internalPath, new LanguageEntryImpl(LanguageEntry.Type.LIST, arrayValue));
                continue;
            }
            FileReader.flattenJsonElement(internalPath, arrayElement, translationMap);
        }
        if (!arrayValues.isEmpty()) {
            translationMap.put(currentPath, new LanguageEntryImpl(LanguageEntry.Type.LIST, arrayValues));
        }
    }

    static class Parser {
        private static final Pattern KEY_PATTERN = Pattern.compile("<key:([^>]+)>");
        private static final int MAX_RECURSION_DEPTH = 3;

        Parser() {
        }

        public static Map<String, LanguageEntry> processAllEntries(Map<String, LanguageEntry> entries) {
            HashMap<String, LanguageEntry> processed = new HashMap<String, LanguageEntry>(entries);
            for (String key : entries.keySet()) {
                Parser.processEntry(key, entries, processed, 0);
            }
            return processed;
        }

        private static void processEntry(String key, Map<String, LanguageEntry> original, Map<String, LanguageEntry> results, int depth) {
            if (depth >= 3) {
                return;
            }
            LanguageEntry entry = results.get(key);
            if (entry == null) {
                return;
            }
            boolean foundAnyKey = false;
            if (entry.isCollection()) {
                ArrayList<String> processedValues = new ArrayList<String>();
                for (String value : entry.getValues()) {
                    StringBuffer processedValue = new StringBuffer();
                    foundAnyKey = Parser.replaceKeysInString(value, processedValue, original, results, depth + 1);
                    processedValues.add(processedValue.toString());
                }
                if (foundAnyKey) {
                    results.put(key, new LanguageEntryImpl(LanguageEntry.Type.LIST, processedValues));
                }
            } else {
                StringBuffer processedValue = new StringBuffer();
                foundAnyKey = Parser.replaceKeysInString(entry.getValue(), processedValue, original, results, depth + 1);
                if (foundAnyKey) {
                    results.put(key, new LanguageEntryImpl(LanguageEntry.Type.STRING, processedValue.toString()));
                }
            }
            if (foundAnyKey) {
                Parser.processEntry(key, original, results, depth + 1);
            }
        }

        private static boolean replaceKeysInString(String input, StringBuffer result, Map<String, LanguageEntry> original, Map<String, LanguageEntry> results, int depth) {
            boolean foundAnyKey = false;
            Matcher matcher = KEY_PATTERN.matcher(input);
            while (matcher.find()) {
                foundAnyKey = true;
                String fullMatch = matcher.group(0);
                String keyName = matcher.group(1);
                String replacement = Parser.getReplacementValue(keyName, fullMatch, original, results, depth + 1);
                matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
            }
            matcher.appendTail(result);
            return foundAnyKey;
        }

        private static String getReplacementValue(String keyName, String fullMatch, Map<String, LanguageEntry> original, Map<String, LanguageEntry> results, int depth) {
            if (original.containsKey(keyName)) {
                Parser.processEntry(keyName, original, results, depth + 1);
                return results.get(keyName).getValue();
            }
            return fullMatch;
        }
    }
}

