/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.wordweaver.loader.impl;

import io.github.milkdrinkers.wordweaver.config.TranslationConfig;
import io.github.milkdrinkers.wordweaver.loader.TranslationLoader;
import io.github.milkdrinkers.wordweaver.loader.impl.FileExtractor;
import io.github.milkdrinkers.wordweaver.loader.impl.FileReader;
import io.github.milkdrinkers.wordweaver.storage.LanguageEntry;
import io.github.milkdrinkers.wordweaver.storage.LanguageLoadException;
import io.github.milkdrinkers.wordweaver.storage.LanguageRegistry;
import io.github.milkdrinkers.wordweaver.storage.impl.LanguageImpl;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTranslationLoader
implements TranslationLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonTranslationLoader.class);
    private final TranslationConfig config;
    private final LanguageRegistry registry;

    public JsonTranslationLoader(TranslationConfig config, LanguageRegistry registry) {
        this.config = config;
        this.registry = registry;
    }

    @Override
    public void extractMissingLanguages() throws IOException {
        try {
            FileExtractor.extractJsonResources(this.config.getLanguagesDirectory(), this.config.getResourcesDirectory());
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to extract missing language files: ", e);
            throw e;
        }
    }

    @Override
    public void updateExistingLanguages() throws IOException {
        try {
            FileExtractor.updateFiles(this.config.getLanguagesDirectory(), this.config.getResourcesDirectory());
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to update existing language files: ", e);
            throw e;
        }
    }

    @Override
    public void loadLanguages() throws IOException {
        try {
            Files.createDirectories(this.config.getLanguagesDirectory(), new FileAttribute[0]);
            try (Stream<Path> files = Files.list(this.config.getLanguagesDirectory());){
                files.filter(path -> path.toString().endsWith(".jsonc") || path.toString().endsWith(".json")).forEach(this::load);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to load language files: ", e);
            throw e;
        }
    }

    private void load(Path file) throws LanguageLoadException {
        try {
            String filename = file.getFileName().toString();
            String language = filename.substring(0, filename.lastIndexOf(46));
            Map<String, LanguageEntry> translations = FileReader.readFile(file);
            LanguageImpl languageFile = new LanguageImpl(language, translations);
            this.registry.register(languageFile);
        }
        catch (LanguageLoadException e) {
            LOGGER.error("Failed to load language file: {}", (Object)file.getFileName(), (Object)e);
            throw e;
        }
    }
}

