/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.wordweaver.service.impl;

import io.github.milkdrinkers.wordweaver.config.TranslationConfig;
import io.github.milkdrinkers.wordweaver.loader.TranslationLoader;
import io.github.milkdrinkers.wordweaver.service.TranslationService;
import io.github.milkdrinkers.wordweaver.storage.Language;
import io.github.milkdrinkers.wordweaver.storage.LanguageEntry;
import io.github.milkdrinkers.wordweaver.storage.LanguageRegistry;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationServiceImpl
implements TranslationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranslationServiceImpl.class);
    private final TranslationConfig config;
    private final LanguageRegistry registry;
    private final TranslationLoader loader;

    public TranslationServiceImpl(TranslationConfig config, LanguageRegistry registry, TranslationLoader loader) {
        this.config = config;
        this.registry = registry;
        this.loader = loader;
        this.initialize();
    }

    private void initialize() {
        try {
            if (this.config.shouldExtractLanguages()) {
                this.loader.extractMissingLanguages();
            }
            if (this.config.shouldUpdateLanguages()) {
                this.loader.updateExistingLanguages();
            }
            this.loader.loadLanguages();
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize translation service", e);
        }
    }

    @Override
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(String key, @Nullable String fallback) {
        Language language = this.registry.getCurrent();
        if (language == null) {
            return this.config.getMissingTranslationHandler().handle(this.config, this.registry, key, fallback);
        }
        LanguageEntry value = language.get(key);
        if (value == null) {
            return this.config.getMissingTranslationHandler().handle(this.config, this.registry, key, fallback);
        }
        return value.getValue();
    }

    @Override
    public List<String> getStringList(String key) {
        return this.getStringList(key, null);
    }

    @Override
    public List<String> getStringList(String key, List<String> fallback) {
        Language language = this.registry.getCurrent();
        if (language == null) {
            return this.config.getMissingTranslationHandler().handleListString(this.config, this.registry, key, fallback);
        }
        LanguageEntry value = language.get(key);
        if (value == null) {
            return this.config.getMissingTranslationHandler().handleListString(this.config, this.registry, key, fallback);
        }
        return value.getValues();
    }

    @Override
    public Component getComponent(String key) {
        return this.getComponent(key, null);
    }

    @Override
    public Component getComponent(String key, Component fallback) {
        Language language = this.registry.getCurrent();
        if (language == null) {
            return this.config.getMissingTranslationHandler().handle(this.config, this.registry, key, (Component)null);
        }
        LanguageEntry value = language.get(key);
        if (value == null) {
            return this.config.getMissingTranslationHandler().handle(this.config, this.registry, key, (Component)null);
        }
        return this.config.getComponentConverter().apply(value.getValue());
    }

    @Override
    public List<Component> getComponentList(String key) {
        return this.getComponentList(key, null);
    }

    @Override
    public List<Component> getComponentList(String key, List<Component> fallback) {
        Language language = this.registry.getCurrent();
        if (language == null) {
            return this.config.getMissingTranslationHandler().handleListComponent(this.config, this.registry, key, null);
        }
        LanguageEntry value = language.get(key);
        if (value == null) {
            return this.config.getMissingTranslationHandler().handleListComponent(this.config, this.registry, key, null);
        }
        return value.getValues().stream().map(s -> this.config.getComponentConverter().apply((String)s)).collect(Collectors.toList());
    }

    @Override
    public Set<String> getKeys() {
        return this.registry.getKeys();
    }

    @Override
    public void setDefaultLanguage(String language) {
        this.config.setDefaultLanguage(language);
    }

    @Override
    public String getDefaultLanguage() {
        return this.config.getDefaultLanguage();
    }

    @Override
    public void setLanguage(String language) {
        this.config.setCurrentLanguage(language);
    }

    @Override
    public String getLanguage() {
        return this.config.getCurrentLanguage();
    }

    @Override
    public void reload() {
        try {
            this.registry.clear();
            this.loader.loadLanguages();
        }
        catch (Exception e) {
            LOGGER.error("Failed to reload translation service", e);
        }
    }
}

