/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.wordweaver.storage.impl;

import io.github.milkdrinkers.wordweaver.storage.LanguageEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LanguageEntryImpl
implements LanguageEntry {
    private final LanguageEntry.Type type;
    private final String value;
    private final List<String> values;

    public LanguageEntryImpl(LanguageEntry.Type type, String value) {
        this.type = type;
        this.value = value;
        this.values = new ArrayList<String>(Collections.singletonList(value));
    }

    public LanguageEntryImpl(LanguageEntry.Type type, List<String> values) {
        this.type = type;
        StringBuilder builder = new StringBuilder();
        values.forEach(s -> {
            builder.append((String)s);
            if (!s.isEmpty()) {
                builder.append("\n");
            }
        });
        this.value = builder.toString();
        this.values = values;
    }

    @Override
    public LanguageEntry.Type getType() {
        return this.type;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    @Override
    public boolean isCollection() {
        return this.type.equals((Object)LanguageEntry.Type.LIST);
    }
}

