/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.wordweaver.storage.impl;

import io.github.milkdrinkers.wordweaver.storage.Language;
import io.github.milkdrinkers.wordweaver.storage.LanguageEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class LanguageImpl
implements Language {
    private final String languageName;
    private final Map<String, LanguageEntry> translations;

    public LanguageImpl(String languageName, Map<String, LanguageEntry> translations) {
        this.languageName = languageName;
        this.translations = Collections.unmodifiableMap(new HashMap<String, LanguageEntry>(translations));
    }

    @Override
    public String getName() {
        return this.languageName;
    }

    @Override
    public Map<String, LanguageEntry> get() {
        return this.translations;
    }

    @Override
    @Nullable
    public LanguageEntry get(String key) {
        return this.translations.get(key);
    }

    @Override
    public Optional<LanguageEntry> getOptional(String key) {
        return Optional.ofNullable(this.get(key));
    }

    @Override
    public boolean has(String key) {
        return this.translations.containsKey(key);
    }

    @Override
    public Set<String> keys() {
        return Collections.unmodifiableSet(this.translations.keySet());
    }
}

