/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.wordweaver.storage.impl;

import io.github.milkdrinkers.wordweaver.config.TranslationConfig;
import io.github.milkdrinkers.wordweaver.storage.Language;
import io.github.milkdrinkers.wordweaver.storage.LanguageRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public class LanguageRegistryImpl
implements LanguageRegistry {
    private final AtomicReference<Map<String, Language>> languages;
    private final AtomicReference<Set<String>> keys;
    private final TranslationConfig config;
    private final AtomicReference<Language> currentLanguage;
    private final AtomicReference<Language> defaultLanguage;

    public LanguageRegistryImpl(TranslationConfig config) {
        this.config = config;
        this.languages = new AtomicReference(Collections.unmodifiableMap(new HashMap()));
        this.keys = new AtomicReference(Collections.unmodifiableSet(new HashSet()));
        this.currentLanguage = new AtomicReference<Object>(null);
        this.defaultLanguage = new AtomicReference<Object>(null);
    }

    @Override
    @Nullable
    public Language get(String name) {
        return this.languages.get().get(name);
    }

    @Override
    public Optional<Language> getOptional(String name) {
        return Optional.ofNullable(this.get(name));
    }

    @Override
    @Nullable
    public Language getCurrent() {
        return this.currentLanguage.get();
    }

    @Override
    public Optional<Language> getCurrentOptional() {
        return Optional.ofNullable(this.getCurrent());
    }

    @Override
    @Nullable
    public Language getDefault() {
        return this.defaultLanguage.get();
    }

    @Override
    public Optional<Language> getDefaultOptional() {
        return Optional.ofNullable(this.getDefault());
    }

    @Override
    public Set<String> getRegistered() {
        return Collections.unmodifiableSet(this.languages.get().keySet());
    }

    @Override
    public boolean isRegistered(String name) {
        return this.languages.get().containsKey(name);
    }

    @Override
    public Set<String> getKeys() {
        return this.keys.get();
    }

    @Override
    public void register(Language language) {
        HashMap<String, Language> updatedLanguages = new HashMap<String, Language>(this.languages.get());
        updatedLanguages.putIfAbsent(language.getName(), language);
        this.languages.set(Collections.unmodifiableMap(updatedLanguages));
        HashSet<String> updatedKeys = new HashSet<String>(this.getKeys());
        Language newLanguage = (Language)updatedLanguages.get(language.getName());
        if (this.currentLanguage.get() == null && language.getName().equals(this.config.getCurrentLanguage())) {
            this.currentLanguage.set(newLanguage);
            if (newLanguage != null) {
                updatedKeys.addAll(newLanguage.keys());
            }
        }
        if (this.defaultLanguage.get() == null && language.getName().equals(this.config.getDefaultLanguage())) {
            this.defaultLanguage.set(newLanguage);
            if (newLanguage != null) {
                updatedKeys.addAll(newLanguage.keys());
            }
        }
        this.keys.set(Collections.unmodifiableSet(updatedKeys));
    }

    @Override
    public void clear() {
        this.currentLanguage.set(null);
        this.defaultLanguage.set(null);
        this.keys.set(Collections.unmodifiableSet(new HashSet()));
        this.languages.set(Collections.unmodifiableMap(new HashMap()));
    }
}

